% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_values.R
\name{map_values}
\alias{map_values}
\title{Replace Elements of Vectors with New Values}
\usage{
map_values(x, old, new)
}
\arguments{
\item{x}{(\verb{vector())}.}

\item{old}{(\code{vector()})\cr
Vector with values to replace.}

\item{new}{(\code{vector()})\cr
Values to replace with.
Will be forced to the same length as \code{old} with \code{\link[base:rep_len]{base::rep_len()}}.}
}
\value{
(\code{vector()}) of the same length as \code{x}.
}
\description{
Replaces all values in \code{x} which match \code{old} with values in \code{new}.
Values are matched with \code{\link[base:match]{base::match()}}.
}
\examples{
x = letters[1:5]

# replace all "b" with "_b_", and all "c" with "_c_"
old = c("b", "c")
new = c("_b_", "_c_")
map_values(x, old, new)
}
