% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_dor.R
\name{dor}
\alias{dor}
\title{Diagnostic Odds Ratio}
\usage{
dor(truth, response, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{response}{(\code{factor()})\cr
Predicted response labels.
Must have the exactly same two levels and the same length as \code{truth}.}

\item{positive}{(\verb{character(1))}\cr
Name of the positive class.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
labels
in binary classification tasks.
}
\details{
The Diagnostic Odds Ratio is defined as \deqn{
   \frac{\mathrm{TP}/\mathrm{FP}}{\mathrm{FN}/\mathrm{TN}}.
}{
   (TP/FP) / (FN/TN).
}

This measure is undefined if FP = 0 or FN = 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
dor(truth, response, positive = "a")
}
\references{
\url{https://en.wikipedia.org/wiki/Template:DiagnosticTesting_Diagram}
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{bbrier}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fn}()},
\code{\link{fnr}()},
\code{\link{fomr}()},
\code{\link{fp}()},
\code{\link{fpr}()},
\code{\link{gmean}()},
\code{\link{gpr}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{prauc}()},
\code{\link{tn}()},
\code{\link{tnr}()},
\code{\link{tp}()},
\code{\link{tpr}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
