% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_mbrier.R
\name{mbrier}
\alias{mbrier}
\title{Multiclass Brier Score}
\usage{
mbrier(truth, prob, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{prob}{(\code{matrix()})\cr
Matrix of predicted probabilities, each column is a vector of probabilities for a
specific class label.
Columns must be named with levels of \code{truth}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
probabilities
in multiclass classification tasks.
}
\details{
Brier score for multi-class classification problems with \eqn{r} labels defined as \deqn{
   \frac{1}{n} \sum_{i=1}^n \sum_{j=1}^r (I_{ij} - p_{ij})^2.
}{
}
\eqn{I_{ij}}{I_ij} is 1 if observation \eqn{i} has true label \eqn{j}, and 0 otherwise.

Note that there also is the more common definition of the Brier score for binary
classification problems in \code{\link[=bbrier]{bbrier()}}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 2]}{[0, 2]}
\item Minimize: \code{TRUE}
\item Required prediction: \code{prob}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
prob = matrix(runif(3 * 10), ncol = 3)
colnames(prob) = levels(truth)
mbrier(truth, prob)
}
\references{
Brier GW (1950).
\dQuote{Verification of forecasts expressed in terms of probability.}
\emph{Monthly Weather Review}, \bold{78}(1), 1--3.
\doi{10.1175/1520-0493(1950)078<0001:vofeit>2.0.co;2}.
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mauc_aunu}()}
}
\concept{Classification Measures}
\concept{classification_measure}
