% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveFSelect.R
\name{ArchiveFSelect}
\alias{ArchiveFSelect}
\title{Logging Object for Evaluated Feature Sets}
\description{
Container around a \code{\link[data.table:data.table]{data.table::data.table()}} which stores all evaluated
feature sets and performance scores.
}
\section{Data structure}{


The table (\verb{$data}) has the following columns:
\itemize{
\item One column for each feature of the task (\verb{$search_space}).
\item One column for each performance measure (\verb{$codomain}).
\item \code{runtime_learners} (\code{numeric(1)})\cr
Sum of training and predict times logged in learners per
\link[mlr3:ResampleResult]{mlr3::ResampleResult} / evaluation. This does not include potential
overhead time.
\item \code{timestamp} (\code{POSIXct})\cr
Time stamp when the evaluation was logged into the archive.
\item \code{batch_nr} (\code{integer(1)})\cr
Feature sets are evaluated in batches. Each batch has a unique batch
number.
\item \code{uhash} (\code{character(1)})\cr
Connects each feature set to the resampling experiment
stored in the \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.
}

Each row corresponds to a single evaluation of a feature set.

The archive stores additionally a \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}
(\verb{$benchmark_result}) that records the resampling experiments. Each
experiment corresponds to to a single evaluation of a feature set. The table
(\verb{$data}) and the benchmark result (\verb{$benchmark_result}) are linked by the
\code{uhash} column. If the results are viewed with \code{as.data.table()}, both are
joined automatically.
}

\section{Analysis}{


For analyzing the feature selection results, it is recommended to pass the archive to
\code{as.data.table()}. The returned data table is joined with the benchmark result
which adds the \link[mlr3:ResampleResult]{mlr3::ResampleResult} for each feature set.

The archive provides various getters (e.g. \verb{$learners()}) to ease the access.
All getters extract by position (\code{i}) or unique hash (\code{uhash}). For a
complete list of all getters see the methods section.

The benchmark result (\verb{$benchmark_result}) allows to score the feature sets
again on a different measure. Alternatively, measures can be supplied to
\code{as.data.table()}.
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table.ArchiveFSelect(x, unnest = NULL, exclude_columns = "uhash", measures = NULL)}\cr
Returns a tabular view of all evaluated feature sets.\cr
\link{ArchiveFSelect} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
\itemize{
\item \code{x} (\link{ArchiveFSelect})
\item \code{unnest} (\code{character()})\cr
Transforms list columns to separate columns. Set to \code{NULL} if no column
should be unnested.
\item \code{exclude_columns} (\code{character()})\cr
Exclude columns from table. Set to \code{NULL} if no column should be
excluded.
\item \code{measures} (list of \link[mlr3:Measure]{mlr3::Measure})\cr
Score feature sets on additional measures.
}
}
}

\section{Super class}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{ArchiveFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
Stores benchmark result.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveFSelect-learner}{\code{ArchiveFSelect$learner()}}
\item \href{#method-ArchiveFSelect-learners}{\code{ArchiveFSelect$learners()}}
\item \href{#method-ArchiveFSelect-predictions}{\code{ArchiveFSelect$predictions()}}
\item \href{#method-ArchiveFSelect-resample_result}{\code{ArchiveFSelect$resample_result()}}
\item \href{#method-ArchiveFSelect-print}{\code{ArchiveFSelect$print()}}
\item \href{#method-ArchiveFSelect-clone}{\code{ArchiveFSelect$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="add_evals"><a href='../../bbotk/html/Archive.html#method-Archive-add_evals'><code>bbotk::Archive$add_evals()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="best"><a href='../../bbotk/html/Archive.html#method-Archive-best'><code>bbotk::Archive$best()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="clear"><a href='../../bbotk/html/Archive.html#method-Archive-clear'><code>bbotk::Archive$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="initialize"><a href='../../bbotk/html/Archive.html#method-Archive-initialize'><code>bbotk::Archive$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="nds_selection"><a href='../../bbotk/html/Archive.html#method-Archive-nds_selection'><code>bbotk::Archive$nds_selection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-learner"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-learner}{}}}
\subsection{Method \code{learner()}}{
Retrieve \link[mlr3:Learner]{mlr3::Learner} of the i-th evaluation, by position
or by unique hash \code{uhash}. \code{i} and \code{uhash} are mutually exclusive.
Learner does not contain a model. Use \verb{$learners()} to get learners with
models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$learner(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-learners"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-learners}{}}}
\subsection{Method \code{learners()}}{
Retrieve list of trained \link[mlr3:Learner]{mlr3::Learner} objects of the i-th evaluation,
by position or by unique hash \code{uhash}. \code{i} and \code{uhash} are mutually
exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$learners(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-predictions"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-predictions}{}}}
\subsection{Method \code{predictions()}}{
Retrieve list of \link[mlr3:Prediction]{mlr3::Prediction} objects of the i-th evaluation, by
position or by unique hash \code{uhash}. \code{i} and \code{uhash} are mutually
exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$predictions(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-resample_result"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-resample_result}{}}}
\subsection{Method \code{resample_result()}}{
Retrieve \link[mlr3:ResampleResult]{mlr3::ResampleResult} of the i-th evaluation, by position
or by unique hash \code{uhash}. \code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$resample_result(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-print"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveFSelect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveFSelect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
