% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorRFE.R
\name{mlr_fselectors_rfe}
\alias{mlr_fselectors_rfe}
\alias{FSelectorRFE}
\title{Feature Selection with Recursive Feature Elimination}
\source{
Guyon I, Weston J, Barnhill S, Vapnik V (2002).
\dQuote{Gene Selection for Cancer Classification using Support Vector Machines.}
\emph{Machine Learning}, \bold{46}(1), 389--422.
ISSN 1573-0565, \doi{10.1023/A:1012487302797}.
}
\description{
Feature selection using the Recursive Feature Elimination (RFE) algorithm.
Recursive feature elimination iteratively removes features with a low importance score.
Only works with \link[mlr3:Learner]{mlr3::Learner}s that can calculate importance scores (see the section on optional extractors in \link[mlr3:Learner]{mlr3::Learner}).
}
\details{
The learner is trained on all features at the start and importance scores are calculated for each feature.
Then the least important feature is removed and the learner is trained on the reduced feature set.
The importance scores are calculated again and the procedure is repeated until the desired number of features is reached.
The non-recursive option (\code{recursive = FALSE}) only uses the importance scores calculated in the first iteration.

The feature selection terminates itself when \code{n_features} is reached.
It is not necessary to set a termination criterion.

When using a cross-validation resampling strategy, the importance scores of the resampling iterations are aggregated.
The parameter \code{aggregation} determines how the importance scores are aggregated.
By default (\code{"rank"}), the importance score vector of each fold is ranked and the feature with the lowest average rank is removed.
The option \code{"mean"} averages the score of each feature across the resampling iterations and removes the feature with the lowest average score.
Averaging the scores is not appropriate for most importance measures.
}
\section{Archive}{

The \link{ArchiveFSelect} holds the following additional columns:
\itemize{
\item \code{"importance"} (\code{numeric()})\cr
The importance score vector of the feature subset.
}
}

\section{Resources}{

The \href{https://mlr-org.com/gallery.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Utilize the built-in feature importance of models with \href{https://mlr-org.com/gallery/optimization/2023-02-07-recursive-feature-elimination/}{Recursive Feature Elimination}.
}
}

\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("rfe")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

\describe{
\item{\code{n_features}}{\code{integer(1)}\cr
The number of features to select.
By default half of the features are selected.}
\item{\code{feature_fraction}}{\code{double(1)}\cr
Fraction of features to retain in each iteration.
The default 0.5 retrains half of the features.}
\item{\code{feature_number}}{\code{integer(1)}\cr
Number of features to remove in each iteration.}
\item{\code{subset_sizes}}{\code{integer()}\cr
Vector of number of features to retain in each iteration.
Must be sorted in decreasing order.}
\item{\code{recursive}}{\code{logical(1)}\cr
If \code{TRUE} (default), the feature importance is calculated in each iteration.}
\item{\code{aggregation}}{\code{character(1)}\cr
The aggregation method for the importance scores of the resampling iterations.
See details.
}
}

The parameter \code{feature_fraction}, \code{feature_number} and \code{subset_sizes} are mutually exclusive.
}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  fselector = fs("rfe"),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  store_models = TRUE
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}},
\code{\link{mlr_fselectors}}
}
\concept{FSelector}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorRFE}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorRFE-new}{\code{FSelectorRFE$new()}}
\item \href{#method-FSelectorRFE-clone}{\code{FSelectorRFE$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFE-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFE-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFE$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFE-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFE-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFE$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
