% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDplyr.R
\docType{data}
\name{DataBackendDplyr}
\alias{DataBackendDplyr}
\title{DataBackend for dplyr/dbplyr}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:DataBackend]{mlr3::DataBackend}.}
\description{
A \link[mlr3:DataBackend]{mlr3::DataBackend} using \code{\link[dplyr:tbl]{dplyr::tbl()}} from packages \CRANpkg{dplyr}/\CRANpkg{dbplyr}.
This includes \code{\link[tibble:tibble]{tibbles}}.
Allows to let a \link[mlr3:Task]{mlr3::Task} interface an out-of-memory data base.
}
\section{Construction}{
\preformatted{DataBackendDplyr$new(data, primary_key = NULL, strings_as_factors = TRUE)
}
\itemize{
\item \code{data} :: \code{\link[dplyr:tbl]{dplyr::tbl()}}\cr
The data object.
\item \code{primary_key} :: \code{character(1)}\cr
Name of the primary key column.
\item strings_as_factors :: \code{logical(1)} || \code{character()}\cr
Either a character vector of column names to convert to factors, or a single logical flag:
if \code{FALSE}, no column will be converted, if \code{TRUE} all string columns (except the primary key).
The backend is queried for distinct values of the respective columns and their levels are stored in \code{$levels}.
}

Alternatively, use \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}} on a \code{\link[dplyr:tbl]{dplyr::tbl()}} which will
construct a \link{DataBackend} for you.
}

\section{Fields}{

All fields from \link[mlr3:DataBackend]{mlr3::DataBackend}, and additionally:
\itemize{
\item \code{levels} :: named \code{list()}\cr
List of factor levels, named with column names.
The columns get automatically converted to factors in \code{$data()} and \code{head()}.
}
}

\section{Methods}{

All methods from \link[mlr3:DataBackend]{mlr3::DataBackend}.
}

\examples{
# Backend using a in-memory tibble
data = tibble::as_tibble(iris)
data$Sepal.Length[1:30] = NA
data$row_id = 1:150
b = DataBackendDplyr$new(data, primary_key = "row_id")

# Object supports all accessors of DataBackend
print(b)
b$nrow
b$ncol
b$colnames
b$data(rows = 100:101, cols = "Species")
b$distinct(b$rownames, "Species")

# Classification task using this backend
task = mlr3::TaskClassif$new(id = "iris_tibble", backend = b, target = "Species")
print(task)
task$head()

# Create a temporary SQLite data base
con = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
dplyr::copy_to(con, data)
tbl = dplyr::tbl(con, "data")

# Define a backend on a subset of the data base
tbl = dplyr::select_at(tbl, setdiff(colnames(tbl), "Sepal.Width")) # do not use column "Sepal.Width"
tbl = dplyr::filter(tbl, row_id \%in\% 1:120) # Use only first 120 rows
b = DataBackendDplyr$new(tbl, primary_key = "row_id")
print(b)

# Query disinct values
b$distinct(b$rownames, "Species")

# Query number of missing values
b$missings(b$rownames, b$colnames)

# Note that SQLite does not support factors, column Species has been converted to character
lapply(b$head(), class)

# Cleanup
rm(tbl)
DBI::dbDisconnect(con)
}
\keyword{datasets}
