% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchmark.R
\name{batchmark}
\alias{batchmark}
\title{Benchmark Experiments on Batch Systems}
\usage{
batchmark(
  design,
  store_models = FALSE,
  reg = batchtools::getDefaultRegistry(),
  renv_project = NULL
)
}
\arguments{
\item{design}{(\code{\link[=data.frame]{data.frame()}})\cr
Data frame (or \code{\link[data.table:data.table]{data.table::data.table()}}) with three columns: "task", "learner", and "resampling".
Each row defines a resampling by providing a \link[mlr3]{Task}, \link[mlr3]{Learner} and an instantiated \link[mlr3]{Resampling} strategy.
The helper function \code{\link[mlr3:benchmark_grid]{benchmark_grid()}} can assist in generating an exhaustive design (see examples) and
instantiate the \link[mlr3]{Resampling}s per \link[mlr3]{Task}.
Additionally, you can set the additional column 'param_values', see \code{\link[mlr3:benchmark_grid]{benchmark_grid()}}.}

\item{store_models}{(\code{logical(1)})\cr
Store the fitted model in the resulting object=
Set to \code{TRUE} if you want to further analyse the models or want to
extract information like variable importance.}

\item{reg}{\link[batchtools:makeExperimentRegistry]{batchtools::ExperimentRegistry}.}

\item{renv_project}{\code{character(1)}\cr
Path to a renv project.
If not \code{NULL}, the renv project is activated in the job environment.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}} with ids of created jobs (invisibly).
}
\description{
This function provides the functionality to leave the interface of \CRANpkg{mlr3} for the computation
of benchmark experiments and switch over to \CRANpkg{batchtools} for a more fine grained control over
the execution.

\code{batchmark()} populates a \link[batchtools:makeExperimentRegistry]{batchtools::ExperimentRegistry} with jobs in a \code{\link[mlr3:benchmark]{mlr3::benchmark()}} fashion.
Each combination of \link[mlr3:Task]{mlr3::Task} and \link[mlr3:Resampling]{mlr3::Resampling} defines a \link[batchtools:addProblem]{batchtools::Problem},
each \link[mlr3:Learner]{mlr3::Learner} is an \link[batchtools:addAlgorithm]{batchtools::Algorithm}.

After the jobs have been submitted and are terminated, results can be collected with \code{\link[=reduceResultsBatchmark]{reduceResultsBatchmark()}}
which returns a \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} and thus to return to the interface of \CRANpkg{mlr3}.
}
\examples{
tasks = list(mlr3::tsk("iris"), mlr3::tsk("sonar"))
learners = list(mlr3::lrn("classif.featureless"), mlr3::lrn("classif.rpart"))
resamplings = list(mlr3::rsmp("cv", folds = 3), mlr3::rsmp("holdout"))

design = mlr3::benchmark_grid(
  tasks = tasks,
  learners = learners,
  resamplings = resamplings
)

reg = batchtools::makeExperimentRegistry(NA)
batchmark(design, reg = reg)
batchtools::submitJobs(reg = reg)

reduceResultsBatchmark(reg = reg)
}
