% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_convert.R
\name{auto_convert}
\alias{auto_convert}
\title{Column Auto-Converter}
\usage{
auto_convert(value, id, type, levels)
}
\arguments{
\item{value}{(any)\cr
New values to convert in order to match \code{type}.}

\item{id}{(\code{character(1)})\cr
Name of the column, used in error messages.}

\item{type}{(\code{character(1)})\cr
Type to convert \code{values} to.}

\item{levels}{(\code{character()} | \code{NULL})\cr
Levels to use for conversion to \code{factor} or \code{ordered}.}
}
\value{
Vector \code{value} converted to type \code{type}.
}
\description{
Set of rules to automatically convert column types.
This is used during \code{rbind}-ing of \link{Task}s, but also in some pipe operators in
\CRANpkg{mlr3pipelines}.

All rules are stored as functions in \link[=mlr_reflections]{mlr_reflections$auto_converters}.
}
\keyword{internal}
