% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\alias{partition.TaskRegr}
\alias{partition.TaskClassif}
\title{Manually Partition into Training and Test Set}
\usage{
partition(task, ratio = 0.67, stratify = TRUE, ...)

\method{partition}{TaskRegr}(task, ratio = 0.67, stratify = TRUE, bins = 3L, ...)

\method{partition}{TaskClassif}(task, ratio = 0.67, stratify = TRUE, ...)
}
\arguments{
\item{task}{(\link{Task})\cr
Task to operate on.}

\item{ratio}{(\code{numeric(1)})\cr
Ratio of observations to put into the training set.}

\item{stratify}{(\code{logical(1)})\cr
If \code{TRUE}, stratify on the target variable.
For regression tasks, the target variable is first cut into \code{bins} bins.
See \code{Task$add_strata()}.}

\item{...}{(any)\cr
Additional arguments, currently not used.}

\item{bins}{(\code{integer(1)})\cr
Number of bins to cut the target variable into for stratification.}
}
\description{
Creates a split of the row ids of a \link{Task} into a training set and a test set while
optionally stratifying on the target column.
}
\examples{
# regression task
task = tsk("boston_housing")

# roughly equal size split while stratifying on the binned response
split = partition(task, ratio = 0.5)
data = data.frame(
  y = c(task$truth(split$train), task$truth(split$test)),
  split = rep(c("train", "predict"), lengths(split))
)
boxplot(y ~ split, data = data)


# classification task
task = tsk("pima")
split = partition(task)

# roughly same distribution of the target label
prop.table(table(task$truth(split$train)))
prop.table(table(task$truth(split$test)))
}
