% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_measures.R
\docType{data}
\name{mlr_measures}
\alias{mlr_measures}
\title{Dictionary of Performance Measures}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.}
\description{
A simple \link{Dictionary} storing objects of class \link{Measure}.
Each measure has an associated help page, see \code{mlr_measures_[id]}.
}
\section{Methods}{

See \link{Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict)}\cr
\link{Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with fields "key", "task_type", "predict_type",
and "packages" as columns.
}
}

\examples{
as.data.table(mlr_measures)
mlr_measures$get("classif.ce")
}
\seealso{
Example measures:
\itemize{
\item \code{\link[=mlr_measures_classif.auc]{classif.auc}}.
\item \code{\link[=mlr_measures_time_train]{time_train}}.
}

Other Dictionary: \code{\link{mlr_generators}},
  \code{\link{mlr_learners}},
  \code{\link{mlr_resamplings}}, \code{\link{mlr_tasks}}

Other Measure: \code{\link{MeasureClassif}},
  \code{\link{MeasureRegr}}, \code{\link{Measure}}
}
\concept{Dictionary}
\concept{Measure}
\keyword{datasets}
