% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{makeFilter}
\alias{makeFilter}
\title{Create a feature filter.}
\usage{
makeFilter(name, desc, pkg, supported.tasks, supported.features, fun)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Identifier for the filter.}

\item{desc}{[\code{character(1)}]\cr
Short description of the filter.}

\item{pkg}{[\code{character(1)}]\cr
Source package where the filter is implemented.}

\item{supported.tasks}{[\code{character}]\cr
Task types supported.}

\item{supported.features}{[\code{character}]\cr
Feature types supported.}

\item{fun}{[\code{function(task, nselect, ...}]\cr
Function which takes a task and returns a named numeric vector of scores,
one score for each feature of \code{task}.
Higher scores mean higher importance of the feature.
At least \code{nselect} features must be calculated, the remaining may be
set to \code{NA} or omitted, and thus will not be selected.
the original order will be restored if necessary.}
}
\value{
Object of class \dQuote{Filter}.
}
\description{
Creates and registers custom feature filters. Implemented filters
can be listed with \code{\link{listFilterMethods}}. Additional
documentation for the \code{fun} parameter specific to each filter can
be found in the description.

Filter \dQuote{permutation.importance} computes a loss function between predictions made by a
learner before and after a feature is permuted. Special arguments to the filter function are
\code{imp.learner}, a [\code{\link{Learner}} or \code{character(1)}] which specifies the learner
to use when computing the permutation importance, \code{contrast}, a \code{function} which takes two
numeric vectors and returns one (default is the difference), \code{aggregation}, a \code{function} which
takes a \code{numeric} and returns a \code{numeric(1)} (default is the mean), \code{nperm},
an \code{integer(1)}, and \code{replace}, a \code{logical(1)} which determines whether the feature being
permuted is sampled with or without replacement.
}

