% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{makeFilter}
\alias{makeFilter}
\title{Create a feature filter}
\usage{
makeFilter(name, desc, pkg, supported.tasks, supported.features, fun)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Identifier for the filter.}

\item{desc}{[\code{character(1)}]\cr
Short description of the filter.}

\item{pkg}{[\code{character(1)}]\cr
Source package where the filter is implemented.}

\item{supported.tasks}{[\code{character}]\cr
Task types supported.}

\item{supported.features}{[\code{character}]\cr
Feature types supported.}

\item{fun}{[\code{function(task, nselect, ...}]\cr
Function which takes a task and returns a named numeric vector of scores,
one score for each feature of \code{task}.
Higher scores mean higher importance of the feature.
At least \code{nselect} features must be calculated, the remaining may be
set to \code{NA} or omitted, and thus will not be selected.
the original order will be restored if necessary.}
}
\value{
Object of class \dQuote{Filter}.
}
\description{
Creates and registers custom feature filters. Implemented filters
can be listed with \code{\link{listFilterMethods}}.
}

