% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRankMatrixAsBar.R
\name{plotRankMatrixAsBar}
\alias{plotRankMatrixAsBar}
\title{Plot a rank-matrix as a barplot.}
\usage{
plotRankMatrixAsBar(obj, pos = NULL)
}
\arguments{
\item{obj}{[\code{RankMatrixAsBarData}]\cr
Output of a \code{\link{generateRankMatrixAsBarData}} function.}

\item{pos}{[\code{character(1)}]
Optionally set how the bars are positioned in \code{\link{ggplot2}}. \cr
Overwrites the one created in \code{\link{generateRankMatrixAsBarData}}. \cr
\dQuote{tile} plots a heatmap with \code{task} as the y-axis.\cr
Allows identification of the performance in a special task.\cr
\dQuote{stack} plots a stacked barplot. \cr
Allows for comparison of learners within and and accross ranks.\cr
\dQuote{dodge} plots a barplot with bars next to each other instead
of stacked bars.\cr}
}
\value{
ggplot2 plot object.
}
\description{
Plots a barchart from the ranks of algorithms. Alternatively
tiles can be plotted for every rank-task combination, see \code{pos}
for details. The x-axis accross all plots is the ranks of a learner.id.
Areas are always coloured corresponding to the learner.
}
\examples{
lrns = list(makeLearner("classif.nnet"), makeLearner("classif.rpart"))
tasks = list(iris.task, sonar.task)
rdesc = makeResampleDesc("CV", iters = 2L)
meas = list(acc, mmce)
res = benchmark(lrns, tasks, rdesc, meas)
r = generateRankMatrixAsBarData(res)
plotRankMatrixAsBar(r, "tile")

}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}}

Other plot: \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

