% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotROCRCurves.R
\name{plotROCRCurves}
\alias{plotROCRCurves}
\title{Visualize binary classification predictions via ROCR ROC curves.}
\usage{
plotROCRCurves(obj, meas1 = "tpr", meas2 = "fpr", avg = "threshold",
  cols = NULL, ltys = NULL, add.legend = NULL, add.diag = TRUE,
  perf.args = list(), legend.args = list(), task.id = NULL)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{meas1}{[\code{character(1)}]\cr
Measure on x-axis. Note that this is a measure name from *ROCR* and not from mlr!
Default is \dQuote{tpr}.}

\item{meas2}{[\code{character(1)}]\cr
Measure on y-axis. Note that this is a measure name from *ROCR* and not from mlr!
Default is \dQuote{fpr}.}

\item{avg}{[\code{character(1)}]\cr
How to average results from resampling.
Default is \dQuote{threshold}.}

\item{cols}{[\code{character}]\cr
Colors of curves. Single strings are replicated to desired length.
Default is to use \code{\link{rainbow}}.}

\item{ltys}{[\code{integer}]\cr
Line types of curves. Single ints are replicated to desired length.
Default is to use 1.}

\item{add.legend}{[\code{logical(1)}]\cr
Add legend to plot?
Default is \code{TRUE} if more than one ROC curve is drawn.}

\item{add.diag}{[\code{logical(1)}]\cr
Add main diagonal to plot via \code{\link{abline}}?
Default is \code{TRUE}.}

\item{perf.args}{[named \code{list}]\cr
Further arguments passed to ROCR's \code{\link[ROCR]{performance}}.
Usually not needed and \code{meas1} and \code{meas2} are set internally.
Default is an empty list.}

\item{legend.args}{[named \code{list}]\cr
Further arguments passed to \code{\link{legend}}.
Default is to display the names or learner ids of \code{obj},
to set \code{col} and \code{fill} to \code{cols}, to set \code{lty} to \code{ltys},
and to draw in \dQuote{bottomright}.}

\item{task.id}{[\code{character(1)}]\cr
Selected task in \code{\link{BenchmarkResult}} to do plots for, ignored otherwise.
Default is first task.}
}
\value{
[\code{invisible(NULL)}].
}
\description{
Plot is generated by calling \code{\link{asROCRPrediction}},
ROCR's \code{\link[ROCR]{performance}},
then ROCR's \code{plot} function.

See these methods in ROCR for further info.
}
\examples{
\dontrun{
lrn1 = makeLearner("classif.logreg", predict.type = "prob")
lrn2 = makeLearner("classif.rpart", predict.type = "prob")
b = benchmark(list(lrn1, lrn2), pid.task)
z = plotROCRCurves(b)
}
}
\seealso{
Other predict: \code{\link{asROCRPrediction}};
  \code{\link{getProbabilities}};
  \code{\link{plotViperCharts}};
  \code{\link{predict.WrappedModel}};
  \code{\link{setPredictThreshold}};
  \code{\link{setPredictType}}

Other roc: \code{\link{asROCRPrediction}};
  \code{\link{plotViperCharts}}
}

