% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tuneThreshold}
\alias{tuneThreshold}
\title{Tune prediction threshold.}
\usage{
tuneThreshold(pred, measure, task, model, nsub = 20L, control = list())
}
\arguments{
\item{pred}{[\code{\link{Prediction}}]\cr
Prediction object.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure to optimize.}

\item{task}{[\code{\link{Task}}]\cr
Learning task. Rarely neeeded,
only when required for the performance measure.}

\item{model}{[\code{\link{WrappedModel}}]\cr
Fitted model. Rarely neeeded,
only when required for the performance measure.}

\item{nsub}{[\code{integer(1)}]\cr
Passed to \code{\link[BBmisc]{optimizeSubInts}} for 2class problems.
Default is 20.}

\item{control}{[\code{list}]\cr
Control object for \code{\link[cmaes]{cma_es}} when used.
Default is empty list.}
}
\value{
[\code{list}]. A named list with with the following components:
  \code{th} is the optimal threshold, \code{perf} the performance value.
}
\description{
Optimizes the threshold of prediction based on probabilities.
Uses \code{\link[BBmisc]{optimizeSubInts}} for 2class problems and \code{\link[cmaes]{cma_es}}
for multiclass problems.
}
\seealso{
Other tune: \code{\link{ModelMultiplexer}},
  \code{\link{makeModelMultiplexer}};
  \code{\link{TuneControl}},
  \code{\link{TuneControlCMAES}},
  \code{\link{TuneControlGenSA}},
  \code{\link{TuneControlGrid}},
  \code{\link{TuneControlIrace}},
  \code{\link{TuneControlRandom}},
  \code{\link{makeTuneControlCMAES}},
  \code{\link{makeTuneControlGenSA}},
  \code{\link{makeTuneControlGrid}},
  \code{\link{makeTuneControlIrace}},
  \code{\link{makeTuneControlRandom}};
  \code{\link{getTuneResult}};
  \code{\link{makeModelMultiplexerParamSet}};
  \code{\link{makeTuneWrapper}}; \code{\link{tuneParams}}
}

