% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capLargeValues.R
\name{capLargeValues}
\alias{capLargeValues}
\title{Convert large/infinite numeric values in a data.frame or task.}
\usage{
capLargeValues(obj, target = character(0L), cols = NULL, threshold = Inf,
  impute = threshold, what = "abs")
}
\arguments{
\item{obj}{(\link{data.frame} | \link{Task})\cr
Input data.}

\item{target}{(\link{character})\cr
Name of the column(s) specifying the response.
Target columns will not be capped.
Default is \code{character(0)}.}

\item{cols}{(\link{character})\cr
Which columns to convert.
Default is all numeric columns.}

\item{threshold}{(\code{numeric(1)})\cr
Threshold for capping.
Every entry whose absolute value is equal or larger is converted.
Default is \code{Inf}.}

\item{impute}{(\code{numeric(1)})\cr
Replacement value for large entries.
Large negative entries are converted to \code{-impute}.
Default is \code{threshold}.}

\item{what}{(\code{character(1)})\cr
What kind of entries are affected?
\dQuote{abs} means \code{abs(x) > threshold},
\dQuote{pos} means \code{abs(x) > threshold && x > 0},
\dQuote{neg} means \code{abs(x) > threshold && x < 0}.
Default is \dQuote{abs}.}
}
\value{
(\link{data.frame})
}
\description{
Convert numeric entries which large/infinite (absolute) values
in a data.frame or task.
Only numeric/integer columns are affected.
}
\examples{
capLargeValues(iris, threshold = 5, impute = 5)
}
\seealso{
Other eda_and_preprocess: \code{\link{createDummyFeatures}},
  \code{\link{dropFeatures}},
  \code{\link{mergeSmallFactorLevels}},
  \code{\link{normalizeFeatures}},
  \code{\link{removeConstantFeatures}},
  \code{\link{summarizeColumns}}
}
