% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuneMultiCritControl.R,
%   R/TuneMultiCritControlGrid.R, R/TuneMultiCritControlNSGA2.R,
%   R/TuneMultiCritControlRandom.R
\name{TuneMultiCritControl}
\alias{TuneMultiCritControl}
\alias{TuneMultiCritControlGrid}
\alias{TuneMultiCritControlRandom}
\alias{TuneMultiCritControlNSGA2}
\alias{makeTuneMultiCritControlGrid}
\alias{makeTuneMultiCritControlNSGA2}
\alias{makeTuneMultiCritControlRandom}
\title{Create control structures for multi-criteria tuning.}
\usage{
makeTuneMultiCritControlGrid(same.resampling.instance = TRUE,
  resolution = 10L, log.fun = "default", final.dw.perc = NULL,
  budget = NULL)

makeTuneMultiCritControlNSGA2(same.resampling.instance = TRUE,
  impute.val = NULL, log.fun = "default", final.dw.perc = NULL,
  budget = NULL, ...)

makeTuneMultiCritControlRandom(same.resampling.instance = TRUE,
  maxit = 100L, log.fun = "default", final.dw.perc = NULL,
  budget = NULL)
}
\arguments{
\item{same.resampling.instance}{[\code{logical(1)}]\cr
Should the same resampling instance be used for all evaluations to reduce variance?
Default is \code{TRUE}.}

\item{resolution}{[\code{integer}]\cr
Resolution of the grid for each numeric/integer parameter in \code{par.set}.
For vector parameters, it is the resolution per dimension.
Either pass one resolution for all parameters, or a named vector.
See \code{\link[ParamHelpers]{generateGridDesign}}.
Default is 10.}

\item{log.fun}{[\code{function} | \code{character(1)}]\cr
Function used for logging. If set to \dQuote{default} (the default), the evaluated design points, the resulting
performances, and the runtime will be reported.
If set to \dQuote{memory}, the memory usage for each evaluation will also be displayed, with a small increase
in run time.
Otherwise a function with arguments \code{learner}, \code{resampling}, \code{measures},
\code{par.set}, \code{control}, \code{opt.path}, \code{dob}, \code{x}, \code{y}, \code{remove.nas},
\code{stage}, and \code{prev.stage} is expected.
The default displays the performance measures, the time needed for evaluating,
the currently used memory and the max memory ever used before
(the latter two both taken from \code{\link{gc}}).
See the implementation for details.}

\item{final.dw.perc}{[\code{boolean}]\cr
If a Learner wrapped by a \code{\link{makeDownsampleWrapper}} is used, you can define the value of \code{dw.perc} which is used to train the Learner with the final parameter setting found by the tuning.
Default is \code{NULL} which will not change anything.}

\item{budget}{[\code{integer(1)}]\cr
Maximum budget for tuning. This value restricts the number of function
evaluations. In case of \code{makeTuneMultiCritControlGrid} this number
must be identical to the size of the grid. For
\code{makeTuneMultiCritControlRandom} the \code{budget} equals the number
of iterations (\code{maxit}) performed by the random search algorithm.
And in case of \code{makeTuneMultiCritControlNSGA2} the \code{budget}
corresponds to the product of the maximum number of generations
(\code{max(generations)}) + 1 (for the initial population) and the size of
the population (\code{popsize}).}

\item{impute.val}{[\code{numeric}]\cr
If something goes wrong during optimization (e.g. the learner crashes),
this value is fed back to the tuner, so the tuning algorithm does not abort.
It is not stored in the optimization path, an NA and a corresponding error message are
logged instead.
Note that this value is later multiplied by -1 for maximization measures internally, so you
need to enter a larger positive value for maximization here as well.
Default is the worst obtainable value of the performance measure you optimize for when
you aggregate by mean value, or \code{Inf} instead.
For multi-criteria optimization pass a vector of imputation values, one for each of your measures,
in the same order as your measures.}

\item{...}{[any]\cr
Further control parameters passed to the \code{control} arguments of
\code{\link[cmaes]{cma_es}} or \code{\link[GenSA]{GenSA}}, as well as
towards the \code{tunerConfig} argument of \code{\link[irace]{irace}}.}

\item{maxit}{[\code{integer(1)}]\cr
Number of iterations for random search.
Default is 100.}
}
\value{
[\code{\link{TuneMultiCritControl}}]. The specific subclass is one of
  \code{\link{TuneMultiCritControlGrid}}, \code{\link{TuneMultiCritControlRandom}},
  \code{\link{TuneMultiCritControlNSGA2}}.
}
\description{
The following tuners are available:
\describe{
  \item{makeTuneMultiCritControlGrid}{Grid search. All kinds of parameter types can be handled.
    You can either use their correct param type and \code{resolution},
    or discretize them yourself by always using \code{\link[ParamHelpers]{makeDiscreteParam}}
    in the \code{par.set} passed to \code{\link{tuneParams}}.}
  \item{makeTuneMultiCritControlRandom}{Random search. All kinds of parameter types can be handled.}
  \item{makeTuneMultiCritControlNSGA2}{Evolutionary method \code{\link[mco]{nsga2}}.
    Can handle numeric(vector) and integer(vector) hyperparameters, but no dependencies.
    For integers the internally proposed numeric values are automatically rounded.}
}
}
\seealso{
Other tune_multicrit: \code{\link{plotTuneMultiCritResultGGVIS}},
  \code{\link{plotTuneMultiCritResult}},
  \code{\link{tuneParamsMultiCrit}}
}
