% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_modwt.R
\encoding{UTF-8}
\name{dis_modwt}
\alias{dis_modwt}
\title{Constructs a pairwise distance matrix based on the maximum overlap discrete wavelet transform}
\usage{
dis_modwt(X, wf = "d4", J = floor(log(nrow(X[[1]]))) - 1, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{wf}{The wavelet filter (default is 'd4').}

\item{J}{The maximum allowable number of scales.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{MODWT}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{MODWT}}.
}
\description{
\code{dis_modwt} returns a pairwise distance matrix based on the dissimilarity
introduced by \insertCite{d2012wavelets;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined
as
\deqn{d_{MODWT}(\boldsymbol X_T, \boldsymbol Y_T)=\Big|||\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{WV}-
\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{WV}||^2+||\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{WC}-
\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{WC}||^2\Big|^{1/2},}
where \eqn{\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{WV}} and \eqn{\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{WV}} are vectors
containing the estimated wavelet variances within \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively, and
\eqn{\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{WC}} and \eqn{\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{WC}} are vectors
containing the estimated wavelet correlations within \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively.
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_modwt(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_cor
feature_dataset <- dis_modwt(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{d2012wavelets}{mlmts}

}
}
\seealso{
\code{\link[waveslim]{modwt}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
