% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{center}
\alias{center}
\title{Center a data set based on a \code{\link{mp_data}}}
\usage{
center(data, all = FALSE, ...)
}
\arguments{
\item{data}{a \code{\link{mp_data}} or a \code{\link{list}} of \code{\link{mp_data}}.}

\item{all}{a logical value to center all variables based on model defaults}

\item{...}{see details below}
}
\value{
For \code{ndata = 1} a single \code{\link{data.frame}} is returned.
If a list of data sets are included then they will be contained in a \code{\link{list}}.
Each \code{\link{data.frame}} has an additional \code{center} attribute which denotes
the centering strategy used.
}
\description{
Provides multilevel centering of a \code{\link{mp_data}} data set.
}
\details{
The \code{...} needs to be the variable's name followed by equals and the centering
strategy requested. There are three different strategies available:
\itemize{
\item \code{cwc}  = centering within cluster
\item \code{cgm}  = centering with group mean
\item \code{none} = no centering
}

If \code{all} is set to \code{TRUE} then the default centering will be used unless
overwritten by specifying a specific centering strategy.
}
\examples{
# Create Model
model <- (
    outcome('Y')
    + within_predictor('X')
    + effect_size(icc = 0.1)
)
# Set seed
set.seed(198723)

# Create data set with default centering
model |> generate(5, 50) |> center(all = TRUE) -> mydata

# Create data centering X with cwc
model |> generate(5, 50) |> center(X = cwc) -> mydata

# See centering strategy
attr(mydata, 'center')
}
