% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.mkinfit.R
\name{update.mkinfit}
\alias{update.mkinfit}
\title{Update an mkinfit model with different arguments}
\usage{
\method{update}{mkinfit}(object, ..., evaluate = TRUE)
}
\arguments{
\item{object}{An mkinfit object to be updated}

\item{\dots}{Arguments to \code{\link{mkinfit}} that should replace
the arguments from the original call. Arguments set to NULL will
remove arguments given in the original call}

\item{evaluate}{Should the call be evaluated or returned as a call}
}
\description{
This function will return an updated mkinfit object. The fitted degradation
model parameters from the old fit are used as starting values for the
updated fit. Values specified as 'parms.ini' and/or 'state.ini' will
override these starting values.
}
\examples{
\dontrun{
fit <- mkinfit("DFOP", subset(FOCUS_2006_D, value != 0), quiet = TRUE)
update(fit, error_model = "tc")
}
}
