% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_kernel_funcs.R
\name{truncated_lognormal_pred_kernel}
\alias{truncated_lognormal_pred_kernel}
\title{Truncated lognormal predation kernel}
\usage{
truncated_lognormal_pred_kernel(ppmr, beta, sigma)
}
\arguments{
\item{ppmr}{A vector of predator/prey size ratios}

\item{beta}{The preferred predator/prey size ratio}

\item{sigma}{The width parameter of the log-normal kernel}
}
\value{
A vector giving the value of the predation kernel at each of the
predator/prey mass ratios in the \code{ppmr} argument.
}
\description{
This is like the \code{\link[=lognormal_pred_kernel]{lognormal_pred_kernel()}} but with an imposed
maximum predator/prey mass ratio
}
\details{
Writing the predator mass as \eqn{w} and the prey mass as \eqn{w_p},
the feeding kernel is given as
\deqn{\phi_i(w, w_p) = 
\exp \left[ \frac{-(\ln(w / w_p / \beta_i))^2}{2\sigma_i^2} \right]
}{\phi_i(w/w_p) = exp(-(ln(w/w_p/\beta_i))^2/(2\sigma_i^2))}
if \eqn{w/w_p} is between 1 and \eqn{\beta_i\exp(3\sigma_i)}{\beta_i exp(3\sigma_i)}
and zero otherwise.
Here \eqn{\beta_i} is the preferred predator-prey mass ratio and \eqn{\sigma_i}
determines the width of the kernel.
These two parameters need to be given in the species parameter dataframe in
the columns \code{beta} and \code{sigma}.

This function is called from \code{\link[=setPredKernel]{setPredKernel()}} to set up the
predation kernel slots in a MizerParams object.
}
\seealso{
Other predation kernel: 
\code{\link{box_pred_kernel}()},
\code{\link{lognormal_pred_kernel}()},
\code{\link{power_law_pred_kernel}()}
}
\concept{predation kernel}
