% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{validEffortVector}
\alias{validEffortVector}
\title{Return valid effort vector}
\usage{
validEffortVector(effort, params)
}
\arguments{
\item{effort}{An vector or scalar.}

\item{params}{A MizerParams object}
}
\value{
A valid effort vector with one entry for each gear, named by gear,
in the same order as in the params object.
}
\description{
A valid effort vector is a named vector with one entry for each gear,
with the gear names in the same order as in the params object.
}
\details{
The function also accepts an \code{effort} that is not yet valid:
\itemize{
\item a scalar, which is then replicated for each gear
\item an unnamed vector, which is then assumed to be in the same order as the
gears in the params object
\item a named vector in which the gear names have a different order than in the
params object. This is then sorted correctly.
\item a named vector which only supplies values for some of the gears.
The effort for the other gears is then set to zero.
}

An \code{effort} argument will lead to an error if it is either
\itemize{
\item unnamed and of the wrong length
\item named but where some names do not match any of the gears
\item not numeric
}
}
\concept{helper}
