% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newMultispeciesParams.R
\name{newMultispeciesParams}
\alias{newMultispeciesParams}
\title{Set up parameters for a general multispecies model}
\usage{
newMultispeciesParams(
  species_params,
  interaction = NULL,
  no_w = 100,
  min_w = 0.001,
  max_w = NA,
  min_w_pp = NA,
  pred_kernel = NULL,
  search_vol = NULL,
  intake_max = NULL,
  metab = NULL,
  p = 0.7,
  z0 = NULL,
  z0pre = 0.6,
  z0exp = n - 1,
  maturity = NULL,
  repro_prop = NULL,
  RDD = "BevertonHoltRDD",
  resource_rate = NULL,
  resource_capacity = NULL,
  n = 2/3,
  r_pp = 10,
  kappa = 1e+11,
  lambda = 2.05,
  w_pp_cutoff = 10,
  resource_dynamics = "resource_semichemostat",
  gear_params = data.frame(),
  selectivity = NULL,
  catchability = NULL,
  initial_effort = NULL
)
}
\arguments{
\item{species_params}{A data frame of species-specific parameter values.}

\item{interaction}{Optional interaction matrix of the species (predator
species x prey species). Entries should be numbers between 0 and 1. By
default all entries are 1. See "Setting interactions" section below.}

\item{no_w}{The number of size bins in the consumer spectrum.}

\item{min_w}{Sets the size of the eggs of all species for which this is not
given in the \code{w_min} column of the \code{species_params} dataframe.}

\item{max_w}{The largest size of the consumer spectrum. By default this is
set to the largest \code{w_inf} specified in the \code{species_params} data
frame.}

\item{min_w_pp}{The smallest size of the resource spectrum. By default this
is set to the smallest value at which any of the consumers can feed.}

\item{pred_kernel}{Optional. An array (species x predator size x prey size)
that holds the predation coefficient of each predator at size on each prey
size. If not supplied, a default is set as described in section "Setting
predation kernel".}

\item{search_vol}{Optional. An array (species x size) holding the search volume
for each species at size. If not supplied, a default is set as described in
the section "Setting search volume".}

\item{intake_max}{Optional. An array (species x size) holding the maximum
intake rate for each species at size. If not supplied, a default is set as
described in the section "Setting maximum intake rate".}

\item{metab}{Optional. An array (species x size) holding the metabolic rate
for each species at size. If not supplied, a default is set as described in
the section "Setting metabolic rate".}

\item{p}{The allometric metabolic exponent. This is only used if \code{metab}
is not given explicitly and if the exponent is not specified in a \code{p}
column in the \code{species_params}.}

\item{z0}{Optional. An array (species x size) holding the external
mortality rate.}

\item{z0pre}{If \code{z0}, the mortality from other sources, is not a column
in the species data frame, it is calculated as z0pre * w_inf ^ z0exp.
Default value is 0.6.}

\item{z0exp}{If \code{z0}, the mortality from other sources, is not a column
in the species data frame, it is calculated as \code{z0pre * w_inf ^ z0exp}.
Default value is \code{n-1}.}

\item{maturity}{Optional. An array (species x size) that holds the proportion
of individuals of each species at size that are mature. If not supplied, a
default is set as described in the section "Setting reproduction".}

\item{repro_prop}{Optional. An array (species x size) that holds the
proportion of consumed energy that a mature individual allocates to
reproduction for each species at size. If not supplied, a default is set as
described in the section "Setting reproduction".}

\item{RDD}{The name of the function calculating the density-dependent
reproduction rate from the density-independent rate. Defaults to
"\code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}".}

\item{resource_rate}{Optional. Vector of resource intrinsic birth rates}

\item{resource_capacity}{Optional. Vector of resource intrinsic carrying capacity}

\item{n}{The allometric growth exponent. This can be overruled for individual
species by including a \code{n} column in the \code{species_params}.}

\item{r_pp}{Coefficient of the intrinsic resource birth rate}

\item{kappa}{Coefficient of the intrinsic resource carrying capacity}

\item{lambda}{Scaling exponent of the intrinsic resource carrying capacity}

\item{w_pp_cutoff}{The upper cut off size of the resource spectrum.
Default is 10 g.}

\item{resource_dynamics}{Function that determines resource dynamics by
calculating the resource spectrum at the next time step from the current
state.}

\item{gear_params}{A data frame with gear-specific parameter values.}

\item{selectivity}{An array (gear x species x size) that holds the
selectivity of each gear for species and size, \eqn{S_{g,i,w}}.}

\item{catchability}{An array (gear x species) that holds the catchability of
each species by each gear, \eqn{Q_{g,i}}.}

\item{initial_effort}{Optional. A number or a named numeric vector specifying
the fishing effort. If a number, the same effort is used for all gears. If
a vector, must be named by gear.}
}
\value{
An object of type \linkS4class{MizerParams}
}
\description{
Sets up a multi-species size spectrum model by filling all slots in the
\linkS4class{MizerParams} object based on user-provided or default
parameters. It does this by creating an empty MizerParams object with
\code{\link[=emptyParams]{emptyParams()}} and then filling the slots by passing its arguments
to \code{\link[=setParams]{setParams()}}. There is a long list of arguments, but almost
all of them have sensible default values. All arguments are described in more
details in the sections below the list.
}
\section{Species parameters}{

The only essential argument is a data frame that contains the species
parameters. The data frame is arranged species by parameter, so each column
of the parameter data frame is a parameter and each row has the values of the
parameters for one of the species in the model.

There are two essential columns that must be included in the species
parameter data.frame and that do not have default values: the
\code{species} column that should hold strings with the names of the
species and the \code{w_inf} column with the asymptotic sizes of the species.

The species_params dataframe also needs to contain the parameters needed
by any predation kernel function or size selectivity function. This will
be mentioned in the appropriate sections below.

For all other species parameters, mizer will calculate default values if they
are not included in the species parameter data frame. They will be
automatically added when the \code{MizerParams} object is created. For these
parameters you can also specify values for only some species and leave the
other entries as NA and the missing values will be set to the defaults.

All the parameters will be mentioned in the following sections.
}

\section{Changes to species params}{

The \code{species_params} slot of the returned MizerParams object may differ
slightly from the data frame supplied as argument to this function in the
following ways:
\itemize{
\item Default values are set for \code{w_min, w_inf, alpha, gear, interaction_resource}.
\item The egg sizes in \code{w_min} are rounded down to lie on a grid point.
}
Note that the other characteristic sizes of the species, like \code{w_mat} and
\code{w_inf}, are not modified to lie on grid points.
}

\section{Size grid}{

A size grid is created so that
the log-sizes are equally spaced. The spacing is chosen so that there will be
\code{no_w} fish size bins, with the smallest starting at \code{min_w} and the largest
starting at \code{max_w}. For \code{w_full} additional size bins are added below
\code{min_w}, with the same log size. The number of extra bins is such that
\code{min_w_pp} comes to lie within the smallest bin.
}

\section{Units in mizer}{

Mizer uses grams to measure weight, centimetres to measure lengths, and
years to measure time.

Mizer is agnostic about whether abundances are given as
\enumerate{
\item numbers per area,
\item numbers per volume or
\item total numbers for the entire study area.
}

You should make the choice most convenient for your application and then
stick with it. If you make choice 1 or 2 you will also have to choose a unit
for area or volume. Your choice will then determine the units for some of
the parameters. This will be mentioned when the parameters are discussed in
the sections below.

You choice will also affect the units of the quantities you may want to
calculate with the model. For example, the yield will be in grams/year/m^2 in
case 1 if you choose m^2 as your measure of area, in grams/year/m^3 in case 2
if you choose m^3 as your unit of volume, or simply grams/year in case 3. The
same comment applies for other measures, like total biomass, which will be
grams/area in case 1, grams/volume in case 2 or simply grams in case 3. When
mizer puts units on axes, for example in \code{plotBiomass}, it will simply
put grams, as appropriate for case 3.

You can convert between these choices. For example, if you use case 1, you
need to multiply with the area of the ecosystem to get the total quantity.
If you work with case 2, you need to multiply by both area and the thickness
of the productive layer. In that respect, case 2 is a bit cumbersome.
}

\section{Setting interactions}{


The interaction matrix \eqn{\theta_{ij}} describes the interaction of each
pair of species in the model. This can be viewed as a proxy for spatial
interaction e.g. to model predator-prey interaction that is not size based.
The values in the interaction matrix are used to scale the encountered food
and predation mortality (see on the website
\href{https://sizespectrum.org/mizer/articles/model_description.html#sec:pref}{the section on predator-prey encounter rate}
and on \href{https://sizespectrum.org/mizer/articles/model_description.html#mortality}{predation mortality}).

It is used when calculating the food encounter rate in \code{\link[=getEncounter]{getEncounter()}} and
the predation mortality rate in \code{\link[=getPredMort]{getPredMort()}}. Its entries are
dimensionless numbers.The values are between 0 (species do not overlap and
therefore do not interact with each other) to 1 (species overlap perfectly).
If all the values in the interaction matrix are set to 1 then predator-prey
interactions are determined entirely by size-preference.

This function checks that the supplied interaction matrix is valid and then
stores it in the \code{interaction} slot of the params object before returning
that object.

The order of the columns and rows of the \code{interaction} argument should be the
same as the order in the species params data frame in the \code{params} object. If
you supply a named array then the function will check the order and warn if
it is different. One way of creating your own interaction matrix is to enter
the data using a spreadsheet program and saving it as a .csv file. The data
can be read into R using the command \code{read.csv()}.

The interaction of the species with the resource are set via a column
\code{interaction_resource} in the \code{species_params} data frame. Again the entries have to
be numbers between 0 and 1. By default this column is set to all 1s.
}

\section{Setting predation kernel}{

\strong{Kernel dependent on predator to prey size ratio}

If the \code{pred_kernel} argument is not supplied, then this function sets a
predation kernel that depends only on the ratio of predator mass to prey
mass, not on the two masses independently. The shape of that kernel is then
determined by the \code{pred_kernel_type} column in species_params.

The default pred_kernel_type is "lognormal". This will call the function
\code{\link[=lognormal_pred_kernel]{lognormal_pred_kernel()}} to calculate the predation kernel.
An alternative pred_kernel type is "box", implemented by the function
\code{\link[=box_pred_kernel]{box_pred_kernel()}}, and "power_law", implemented by the function
\code{\link[=power_law_pred_kernel]{power_law_pred_kernel()}}. These functions require certain species
parameters in the species_params data frame. For the lognormal kernel these
are \code{beta} and \code{sigma}, for the box kernel they are \code{ppmr_min}
and \code{ppmr_max}. They are explained in the help pages for the kernel
functions. Except for \code{beta} and \code{sigma}, no defaults are set for
these parameters. If they are missing from the species_params data frame then
mizer will issue an error message.

You can use any other string as the type. If for example you choose "my" then
you need to define a function \code{my_pred_kernel} that you can model on the
existing functions like \code{\link[=lognormal_pred_kernel]{lognormal_pred_kernel()}}.

When using a kernel that depends on the predator/prey size ratio only, mizer
does not need to store the entire three dimensional array in the MizerParams
object. Such an array can be very big when there is a large number of size
bins. Instead, mizer only needs to store two two-dimensional arrays that hold
Fourier transforms of the feeding kernel function that allow the encounter
rate and the predation rate to be calculated very efficiently. However, if
you need the full three-dimensional array you can calculate it with the
\code{\link[=getPredKernel]{getPredKernel()}} function.

\strong{Kernel dependent on both predator and prey size}

If you want to work with a feeding kernel that depends on predator mass and
prey mass independently, you can specify the full feeding kernel as a
three-dimensional array (predator species x predator size x prey size).

You should use this option only if a kernel dependent only on the
predator/prey mass ratio is not appropriate. Using a kernel dependent on
predator/prey mass ratio only allows mizer to use fast Fourier transform
methods to significantly reduce the running time of simulations.

The order of the predator species in \code{pred_kernel} should be the same
as the order in the species params dataframe in the \code{params} object. If you
supply a named array then the function will check the order and warn if it is
different.
}

\section{Setting search volume}{

The search volume \eqn{\gamma_i(w)} of an individual of species \eqn{i}
and weight \eqn{w} multiplies the predation kernel when
calculating the encounter rate in \code{\link[=getEncounter]{getEncounter()}} and the
predation rate in \code{\link[=getPredRate]{getPredRate()}}.

The name "search volume" is a bit misleading, because \eqn{\gamma_i(w)} does
not have units of volume. It is simply a parameter that determines the rate
of predation. Its units depend on your choice, see section "Units in mizer".
If you have chose to work with total abundances, then it is a rate with units
1/year. If you have chosen to work with abundances per m^2 then it has units
of m^2/year. If you have chosen to work with abundances per m^3 then it has
units of m^3/year.

If the \code{search_vol} argument is not supplied, then the search volume is
set to
\deqn{\gamma_i(w) = \gamma_i w^q_i.}
The values of \eqn{\gamma_i} (the search volume at 1g) and \eqn{q_i} (the
allometric exponent of the search volume) are taken from the \code{gamma} and
\code{q} columns in the species parameter dataframe. If the \code{gamma}
column is not supplied in the species parameter dataframe, a default is
calculated by the \code{\link[=get_gamma_default]{get_gamma_default()}} function. Note that only
for predators of size \eqn{w = 1} gram is the value of the species parameter
\eqn{\gamma_i} the same as the value of the search volume \eqn{\gamma_i(w)}.
}

\section{Setting maximum intake rate}{

The maximum intake rate \eqn{h_i(w)} of an individual of species \eqn{i} and
weight \eqn{w} determines the feeding level, calculated with
\code{\link[=getFeedingLevel]{getFeedingLevel()}}. It is measured in grams/year.

If the \code{intake_max} argument is not supplied, then the maximum intake
rate is set to \deqn{h_i(w) = h_i w^n_i.}
The values of \eqn{h_i} (the maximum intake rate of an individual of size 1
gram) and \eqn{n_i} (the allometric exponent for the intake rate) are taken
from the \code{h} and \code{n} columns in the species parameter dataframe. If
the \code{h} column is not supplied in the species parameter dataframe, it is
calculated by the \code{\link[=get_h_default]{get_h_default()}} function, using \code{f0} and
the \code{k_vb} column, if they are supplied.

If \eqn{h_i} is set to \code{Inf}, fish will consume all encountered food.
}

\section{Setting metabolic rate}{

The metabolic rate is subtracted from the energy income rate to calculate
the rate at which energy is available for growth and reproduction, see
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}. It is measured in grams/year.

If the \code{metab} argument is not supplied, then for each species the
metabolic rate \eqn{k(w)} for an individual of size \eqn{w} is set to
\deqn{k(w) = ks w^p + k w,}
where \eqn{ks w^p} represents the rate of standard metabolism and \eqn{k w}
is the rate at which energy is expended on activity and movement. The values
of \eqn{ks}, \eqn{p} and \eqn{k} are taken from the \code{ks}, \code{p} and
\code{k} columns in the species parameter dataframe. If any of these
parameters are not supplied, the defaults are \eqn{k = 0}, \eqn{p = n} and
\deqn{ks = f_c h \alpha w_{mat}^{n-p},}{ks = f_c * h * alpha * w_mat^(n - p),}
where \eqn{f_c} is the critical feeding level taken from the \code{fc} column
in the species parameter data frame. If the critical feeding level is not
specified, a default of \eqn{f_c = 0.2} is used.
}

\section{Setting external mortality rate}{

The external mortality is all the mortality that is not due to fishing or
predation by predators included in the model. The external mortality could be
due to predation by predators that are not explicitly included in the model
(e.g. mammals or seabirds) or due to other causes like illness. It is a rate
with units 1/year.

The \code{z0} argument allows you to specify an external mortality rate
that depends on species and body size. You can see an example of this in
the Examples section of the help page for \code{\link[=setExtMort]{setExtMort()}}.

If the \code{z0} argument is not supplied, then the external mortality
is assumed to depend only on the species, not on the
size of the individual: \eqn{\mu_{b.i}(w) = z_{0.i}}. The value of the
constant \eqn{z_0} for each species is taken from the \code{z0} column of the
species_params data frame, if that column exists. Otherwise it is calculated
as
\deqn{z_{0.i} = {\tt z0pre}_i\, w_{inf}^{\tt z0exp}.}{z_{0.i} = z0pre_i w_{inf}^{z0exp}.}
}

\section{Setting reproduction}{


\subsection{Investment}{
For each species and at each size, the proportion \eqn{\psi}{psi} of the available energy
that is invested into reproduction is the product of two factors: the
proportion \code{maturity} of individuals that are mature and the proportion
\code{repro_prop} of the energy available to a mature individual that is
invested into reproduction.

If the \code{maturity} argument is not supplied, then it is set to a sigmoidal
maturity ogive that changes from 0 to 1 at around the maturity size:
\deqn{{\tt maturity}(w) = \left[1+\left(\frac{w}{w_{mat}}\right)^{-U}\right]^{-1}.}{
  maturity(w) = [1+(w/w_mat)^(-U)]^(-1)}
(To avoid clutter, we are not showing the species index in the equations.)
The maturity weights are taken from the \code{w_mat} column of the
species_params data frame. Any missing maturity weights are set to 1/4 of the
asymptotic weight in the \code{w_inf} column.
The exponent \eqn{U} determines the steepness of the maturity ogive. By
default it is chosen as \eqn{U = 10}, however this can be overridden by
including a column \code{w_mat25} in the species parameter dataframe that
specifies the weight at which 25\% of individuals are mature, which sets
\eqn{U = \log(3) / \log(w_{mat} / w_{25}).}{U = log(3) / log(w_mat / w_25).}

The sigmoidal function given above would strictly reach 1 only asymptotically.
Mizer instead sets the function equal to 1 already at the species'
maximum size, taken from the compulsory \code{w_inf} column in the
\code{species_params} data frame.

If the \code{repro_prop} argument is not supplied, it is set to the
allometric form
\deqn{{\tt repro\_prop}(w) = \left(\frac{w}{w_{inf}}\right)^{m-n}.}{
  repro_prop(w) = (w/w_inf)^(m - n).}
Here \eqn{n} is the scaling exponent of the energy income rate. Hence
the exponent \eqn{m} determines the scaling of the investment into
reproduction for mature individuals. By default it is chosen to be
\eqn{m = 1} so that the rate at which energy is invested into reproduction
scales linearly with the size. This default can be overridden by including a
column \code{m} in the species parameter dataframe. The asymptotic sizes
are taken from the compulsory \code{w_inf} column in the species_params
data frame.

So finally we have
\deqn{\psi(w) = {\tt maturity}(w){\tt repro\_prop}(w)}{psi(w) = maturity(w) * repro_prop(w)}
}

\subsection{Efficiency}{
The reproductive efficiency, i.e., the proportion of energy allocated to
reproduction that results in egg biomass, is set through the \code{erepro}
column in the species_params data frame. If that is not provided, the default
is set to 1 (which you will want to override). The offspring biomass divided
by the egg biomass gives the rate of egg production, returned by
\code{\link[=getRDI]{getRDI()}}.
}

\subsection{Density dependence}{
The stock-recruitment relationship is an emergent phenomenon in mizer, with
several sources of density dependence. Firstly, the amount of energy invested
into reproduction depends on the energy income of the spawners, which is
density-dependent due to competition for prey. Secondly, the proportion of
larvae that grow up to recruitment size depends on the larval mortality,
which depends on the density of predators, and on larval growth rate, which
depends on density of prey.

Finally, to encode all the density dependence in the stock-recruitment
relationship that is not already included in the other two sources of density
dependence, mizer puts the the density-independent rate of egg production
through a density-dependence function. The result is returned by
\code{\link[=getRDD]{getRDD()}}. The name of the density-dependence function is
specified by the \code{RDD} argument. The default is the Beverton-Holt
function \code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}, which requires an \code{R_max} column
in the species_params data frame giving the maximum egg production rate. If
this column does not exist, it is initialised to \code{Inf}, leading to no
density-dependence. Other functions provided by mizer are
\code{\link[=RickerRDD]{RickerRDD()}} and \code{\link[=SheperdRDD]{SheperdRDD()}} and you can easily use
these as models for writing your own functions.
}
}

\section{Setting fishing}{


\strong{Gears}

In \code{mizer}, fishing mortality is imposed on species by fishing gears. The
total fishing mortality is obtained by summing over the mortality from all
gears,
\deqn{\mu_{f.i}(w) = \sum_g F_{g,i}(w),}
where the fishing mortality \eqn{F_{g,i}(w)} imposed by gear \eqn{g} on
species \eqn{i} at size \eqn{w} is calculated as:
\deqn{F_{g,i}(w) = S_{g,i}(w) Q_{g,i} E_{g},}
where \eqn{S} is the selectivity by species, gear and size, \eqn{Q} is the
catchability by species and gear and \eqn{E} is the fishing effort by gear.

\strong{Selectivity}

The selectivity at size of each gear for each species is saved as a three
dimensional array (gear x species x size). Each entry has a range between 0
(that gear is not selecting that species at that size) to 1 (that gear is
selecting all individuals of that species of that size). This three
dimensional array can be specified explicitly via the \code{selectivity}
argument, but usually mizer calculates it from the \code{gear_params} slot of
the MizerParams object.

To allow the calculation of the \code{selectivity} array, the \code{gear_params} slot
must be a data frame with one row for each gear-species combination. So if
for example a gear can select three species, then that gear contributes three
rows to the \code{gear_params} data frame, one for each species it can select. The
data frame must have columns \code{gear}, holding the name of the gear, \code{species},
holding the name of the species, and \code{sel_func}, holding the name of the
function that calculates the selectivity curve. Some selectivity functions
are included in the package: \code{knife_edge()}, \code{sigmoid_length()},
\code{double_sigmoid_length()}, and \code{sigmoid_weight()}.
Users are able to write their own size-based selectivity function. The first
argument to the function must be \code{w} and the function must return a vector of
the selectivity (between 0 and 1) at size.

Each selectivity function may have parameters. Values for these
parameters must be included as columns in the gear parameters data.frame.
The names of the columns must exactly match the names of the corresponding
arguments of the selectivity function. For example, the default selectivity
function is \code{knife_edge()} that a has sudden change of selectivity from 0 to 1
at a certain size. In its help page you can see that the \code{knife_edge()}
function has arguments \code{w} and \code{knife_edge_size}. The first argument, \code{w}, is
size (the function calculates selectivity at size). All selectivity functions
must have \code{w} as the first argument. The values for the other arguments must
be found in the gear parameters data.frame. So for the \code{knife_edge()}
function there should be a \code{knife_edge_size} column. Because \code{knife_edge()}
is the default selectivity function, the \code{knife_edge_size} argument has a
default value = \code{w_mat}.

In case each species is only selected by one gear, the columns of the
\code{gear_params} data frame can alternatively be provided as columns of the
\code{species_params} data frame, if this is more convenient for the user to set
up. Mizer will then copy these columns over to create the \code{gear_params} data
frame when it creates the MizerParams object. However changing these columns
in the species parameter data frame later will not update the \code{gear_params}
data frame.

\strong{Catchability}

Catchability is used as an additional factor to make the link between gear
selectivity, fishing effort and fishing mortality. For example, it can be set
so that an effort of 1 gives a desired fishing mortality. In this way effort
can then be specified relative to a 'base effort', e.g. the effort in a
particular year.

Catchability is stored as a two dimensional array (gear x species). This can
either be provided explicitly via the \code{catchability} argument, or the
information can be provided via a \code{catchability} column in the \code{gear_params}
data frame.

In the case where each species is selected by only a single gear, the
\code{catchability} column can also be provided in the \code{species_params} data
frame. Mizer will then copy this over to the \code{gear_params} data frame when
the MizerParams object is created.

\strong{Effort}

The initial fishing effort is stored in the \code{MizerParams} object. If it is
not supplied, it is set to zero. The initial effort can be overruled when
the simulation is run with \code{project()}, where it is also possible to specify
an effort that varies through time.
}

\section{Setting resource dynamics}{

By default, mizer uses a semichemostat model to describe the resource
dynamics in each size class independently. This semichemostat dynamics is implemented
by the function \code{\link[=resource_semichemostat]{resource_semichemostat()}}. You can change the
resource dynamics by writing your own function, modelled on
\code{\link[=resource_semichemostat]{resource_semichemostat()}}, and then passing the name of your
function in the \code{resource_dynamics} argument.

The \code{resource_rate} argument is a vector specifying the intrinsic resource
growth rate for each size class. If it is not supplied, then the intrinsic growth
rate \eqn{r(w)} at size \eqn{w}
is set to \deqn{r(w) = r_{pp}\, w^{n-1}.}{r(w) = r_pp w^{n-1}}
The values of \eqn{r_{pp}} and \eqn{n} are taken from the \code{r_pp}
and \code{n} arguments.

The \code{resource_capacity} argument is a vector specifying the intrinsic resource
carrying capacity for each size class. If it is not supplied, then the
intrinsic carrying capacity \eqn{c(w)} at size \eqn{w}
is set to \deqn{c(w) = \kappa\, w^{-\lambda}}{c(w) = \kappa w^{-\lambda}}
for all \eqn{w} less than \code{w_pp_cutoff} and zero for larger sizes.
The values of \eqn{\kappa} and \eqn{\lambda} are taken from the \code{kappa}
and \code{lambda} arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
}
}
\seealso{
Other functions for setting up models: 
\code{\link{newCommunityParams}()},
\code{\link{newTraitParams}()}
}
\concept{functions for setting up models}
