% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_summary_statistic}
\alias{plot_summary_statistic}
\title{Plot summary statistics of behavioural data}
\usage{
plot_summary_statistic(
  data,
  statistic = "precision",
  unit = "degrees",
  id_var = "id",
  response_var = "response",
  target_var = "target",
  set_size_var = NULL,
  condition_var = NULL,
  return_data = FALSE,
  palette = "Dark2"
)
}
\arguments{
\item{data}{A data frame with columns containing: participant identifier
('id_var'); the participants' response per trial ('response_var'); the
target value ('target_var'); and, if applicable, the set size of each
response ('set_size_var'), and the condition of each response
('condition_var').}

\item{statistic}{The summary statistic to plot. This can be set to
"mean_absolute_error", "resultant_vector_length", or "precision".}

\item{unit}{The unit of measurement in the data frame: "degrees"
(measurement is in degrees, from 0 to 360); "degrees_180 (measurement is in
degrees, but limited to 0 to 180); or "radians" (measurement is in radians,
from pi to 2 * pi, but could also be already in -pi to pi).}

\item{id_var}{The column name coding for participant id. If the data is from
a single participant (i.e., there is no id column) set to "NULL".}

\item{response_var}{The column name coding for the participants' responses.}

\item{target_var}{The column name coding for the target value.}

\item{set_size_var}{The column name (if applicable) coding for the set
size of each response.}

\item{condition_var}{The column name (if applicable) coding for the
condition of each response.}

\item{return_data}{A boolean (TRUE or FALSE) indicating whether the data for
the plot should be returned.}

\item{palette}{A character stating the preferred colour palette to use. To
see all available palettes, type display.brewer.all() into the console.}
}
\value{
If \code{return_data} is set to \code{FALSE} (which it is by default),
the function returns a ggplot2 object visualising the summary statistic
averaged across participants (if applicable) per set-size (if applicable)
and condition (if applicable).

If \code{return_data} is set to \code{TRUE}, the function returns a
list with two components:

 \itemize{
 \item \code{plot:} The ggplot2 object.
 \item \code{data:} A data frame with the data used to generate the plot.
 }
}
\description{
Function to plot model-free summary statistics of behavioural data. Users
can plot mean absolute error, resultant vector length, and precision of the
behavioural data.
}
\examples{
plot_summary_statistic(bays2009_full,
                      unit = "radians",
                      statistic = "precision",
                      set_size_var = "set_size",
                      condition_var = "duration")

}
