% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mixfitEM.R
\name{print.mixfitEM}
\alias{print.mixfitEM}
\title{Print Method for Class \code{mixfitEM}}
\usage{
\method{print}{mixfitEM}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{an object of class \code{mixfitEM}}

\item{digits}{the digits to print for the values in the print output. The default
value is from the global option \code{getOption("digits")}.}

\item{...}{other arguments passed to \code{print}}
}
\description{
This function is the print method for the \code{mixfitEM} class.
}
\details{
\code{print.mixfitEM} prints the value of the parameters of a fitted mixture model, together
with some other information like the number of iterations of the EM algorithm, the loglikelihood,
the value of AIC and BIC.
}
\examples{
x <- rmixnormal(200, c(0.5, 0.5), c(2, 5), c(1, 0.7))
fit <- mixfit(x, ncomp = 2)
print(x)

}
\seealso{
\code{\link{mixfit}}
}
