% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{breakpoints}
\alias{breakpoints}
\alias{breakpoints.compdist}
\alias{breakpoints.trans_compdist}
\alias{breakpoints.comp_fit}
\title{Extract Model Breakpoints}
\usage{
breakpoints(O)

\method{breakpoints}{compdist}(O)

\method{breakpoints}{trans_compdist}(O)

\method{breakpoints}{comp_fit}(O)
}
\arguments{
\item{O}{an object for which the extraction of model breakpoints is meaningful.}
}
\value{
Vector of extracted breakpoints form object.
}
\description{
\code{breakpoints} is a generic function which extracts breakpoints from \code{\link{mistr}} composite distribution objects.
}
\examples{
N <- normdist(1, 3)
C <- cauchydist()

CC <- compdist(N, C, weights = c(0.5, 0.5), breakpoints = 1)
breakpoints(CC)
}
\seealso{
\code{\link{parameters}}, \code{\link[stats]{weights}}
}
