% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-simpleSBM_fit.R
\name{SimpleSBM_fit}
\alias{SimpleSBM_fit}
\title{This internal class is designed to adjust a binary Stochastic Block Model in the context of missSBM.}
\description{
This internal class is designed to adjust a binary Stochastic Block Model in the context of missSBM.

This internal class is designed to adjust a binary Stochastic Block Model in the context of missSBM.
}
\details{
It is not designed not be call by the user
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:SimpleSBM]{sbm::SimpleSBM}} -> \code{SimpleSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{type}}{the type of SBM (distribution of edges values, network type, presence of covariates)}

\item{\code{penalty}}{double, value of the penalty term in ICL}

\item{\code{entropy}}{double, value of the entropy due to the clustering distribution}

\item{\code{loglik}}{double: approximation of the log-likelihood (variational lower bound) reached}

\item{\code{ICL}}{double: value of the integrated classification log-likelihood}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimpleSBM_fit$new()}}
\item \href{#method-doVEM}{\code{SimpleSBM_fit$doVEM()}}
\item \href{#method-reorder}{\code{SimpleSBM_fit$reorder()}}
\item \href{#method-clone}{\code{SimpleSBM_fit$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="rNetwork">}\href{../../sbm/html/SBM.html#method-rNetwork}{\code{sbm::SBM$rNetwork()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="plot">}\href{../../sbm/html/SimpleSBM.html#method-plot}{\code{sbm::SimpleSBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="predict">}\href{../../sbm/html/SimpleSBM.html#method-predict}{\code{sbm::SimpleSBM$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="rEdges">}\href{../../sbm/html/SimpleSBM.html#method-rEdges}{\code{sbm::SimpleSBM$rEdges()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="rMemberships">}\href{../../sbm/html/SimpleSBM.html#method-rMemberships}{\code{sbm::SimpleSBM$rMemberships()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="show">}\href{../../sbm/html/SimpleSBM.html#method-show}{\code{sbm::SimpleSBM$show()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for simpleSBM_fit for missSBM purpose
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$new(networkData, clusterInit, covarList = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{networkData}}{a structure to store network under missing data condition: either a matrix possibly with NA, or a missSBM:::partlyObservedNetwork}

\item{\code{clusterInit}}{Initial clustering: a vector with size \code{ncol(adjacencyMatrix)}, providing a user-defined clustering with \code{nbBlocks} levels.}

\item{\code{covarList}}{An optional list with M entries (the M covariates).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doVEM"></a>}}
\if{latex}{\out{\hypertarget{method-doVEM}{}}}
\subsection{Method \code{doVEM()}}{
method to perform estimation via variational EM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$doVEM(
  threshold = 0.01,
  maxIter = 100,
  fixPointIter = 3,
  trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{stop when an optimization step changes the objective function by less than threshold. Default is 1e-4.}

\item{\code{maxIter}}{V-EM algorithm stops when the number of iteration exceeds maxIter. Default is 10}

\item{\code{fixPointIter}}{number of fix-point iterations in the Variational E step. Default is 5.}

\item{\code{trace}}{logical for verbosity. Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reorder"></a>}}
\if{latex}{\out{\hypertarget{method-reorder}{}}}
\subsection{Method \code{reorder()}}{
permute group labels by order of decreasing probability
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$reorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
