% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint}
\alias{confint}
\alias{confint.numeric}
\title{Confidence Intervals for Numeric Vectors}
\usage{
\method{confint}{numeric}(object, parm = qnorm, level = 0.95, ...,
  na.rm = TRUE, ret.attr = TRUE)
}
\arguments{
\item{object}{A numeric vector.}

\item{parm}{Function for quantile calculation.
e.g. \code{qnorm}, \code{qt}}

\item{level}{Size of confidence (0 < size < 1).}

\item{...}{Unused.}

\item{na.rm}{Logical, remove missing values for \code{sd} and \code{mean}.}

\item{ret.attr}{Logical, to include the mean value and function arguments
as attributes of the returned object.}
}
\value{
Returns a numeric vector with the lower and upper range of the
confidence interval.
}
\description{
Calculate confidence intervals for values of a numeric vector.
}
\examples{
#

confint(1:3)
confint(1:3, ret.attr = FALSE)

#
}
\author{
Sven E. Templer
}
