% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.cor.R
\name{test.cor}
\alias{test.cor}
\title{Test for the product-moment correlation coefficient for H0: \eqn{\rho = \rho}0}
\usage{
test.cor(x = NULL, y = NULL, r = NULL, n = NULL, rho = 0,
  alternative = c("two.sided", "less", "greater"), reduced = FALSE,
  conf.level = 0.95, digits = 3, output = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{r}{alternative specification, product-moment correlation coefficient.}

\item{n}{alternative specification, number of observations.}

\item{rho}{a number indicating \eqn{\rho}0, the value under the null hypothesis.}

\item{alternative}{a character string describing the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{reduced}{logical: if \code{TRUE}, compuatation is based on the reduced formula.}

\item{conf.level}{confidence level of the interval.}

\item{digits}{integer indicating the number of decimal places to be displayed.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{test.cor} with following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{dat}       \tab data.frame with x and y (if available) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{res}       \tab list with results, i.e., t or z (test statistic), df (degree of feedom),
                        pval (significance value), r (correlation coefficient),
                        n (sample size), lower (lower limit of CI), upper (upper limit of CI) \cr
}
}
\description{
This function tests the product-moment correlation coefficient for H0: \eqn{\rho = \rho}0,
so that any value for \eqn{\rho}0 can be specified.
}
\details{
Computation is based on  Fisher's z transformation \eqn{\textbf{z} = 0.5 /cdot ln(\frac{1 + r}{1 - r})}. The
difference between the full formula (i.e., \code{reduced = FALSE}) and the reduced formula (i.e., \code{reduced = TRUE})
is that the full formula includes the term \eqn{\frac{\rho}{n - 1}} in the formula of the exectation \emph{E}, i.e.,

\deqn{\emph{E}(\textbf{z}) = 0.5 /cdot ln(\frac{1 + \rho}{1 - \rho}) + \frac{\rho}{n - 1}}

whereas the reduced formula does not include this term, i.e.,

\deqn{\emph{E}(\textbf{z}) = 0.5 /cdot ln(\frac{1 + \rho}{1 - \rho})}

It is recommended to always use the full formula, especially in small samples.
}
\examples{
#--------------------------------------
# Two-sided test
# H0: rho == 0, H1: rho != 0
# r = 0.23, n = 60

test.cor(r = 0.23, n = 120)

#--------------------------------------
# Two-sided test
# H0: rho == 0.4, H1: rho != 0.4
# r = 0.55, n = 120

test.cor(r = 0.55, n = 120, rho = 0.4)

#--------------------------------------
# One-sided test
# H0: rho <= 0.4, H1: rho > 0.4

# Generate random data
dat <- sim.cor(100, rho = 0.4)

test.cor(dat$x, dat$y, rho = 0.4)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
\references{
Cramer, H. (1946). \emph{Mathematical methods of statistics}. Princeton: Princeton Press.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Kubinger, K. D., Rasch, D., & Simeckova, M. (2007). Testing a correlation coefficient's significance:
Using H0: 0 \eqn{< \rho \le \lambda} is preferable to H0: \eqn{\rho = }0. \emph{Psychology Science, 49}, 74-87.
}
\seealso{
\code{\link{size.cor}}, \code{\link{comptest.cor}}, \code{\link{seqtest.cor}}
}

