\name{image3d}
\alias{image3d}
\title{Draw Points on a 3D Grid}
\description{
  Plots points on a three dimensional grid representing values in a
  three dimensional array. Assumes high values are inside and uses alpha
  blending to make outside points more transparent. 
}
\usage{
  image3d(v, x = 1:dim(v)[1], y = 1:dim(v)[2], z = 1:dim(v)[3],
          vlim = quantile(v, c(.9, 1),na.rm=TRUE),
          col = heat.colors(256), alpha.power = 2,
          alpha = ((1:length(col))/ length(col))^alpha.power,
          breaks, sprites = TRUE, jitter = FALSE, 
          radius = min(diff(x), diff(y), diff(z)),
          add = FALSE,...)
}
\arguments{
  \item{v}{three dimensional data array.}
  \item{x,y,z}{locations of grid planes at which values in \code{v} are
    measured.}
  \item{vlim}{minimum and maximum \code{v} values for which points are
    to be drawn.}
  \item{col}{vector of colors for the points as generated by
    \code{heat.colors} or similar functions.}
  \item{alpha.power}{used to calculate the alpha values. The larger the
    power, the smaller the alpha, the more transparent the point. Only
    used if \code{alpha} is not supplied.} 
  \item{alpha}{vector of alpha values between 0 and 1.  The length of
    the vector should be equal to the length of \code{col}.}
  \item{breaks}{breakpoints for the colors; must give one more
    breakpoint than colors.}
  \item{sprites}{logical;  if \code{TRUE}, use \code{sprites3d} to
    draw the points.}
  \item{radius}{radius used in \code{sprites3d}.}
  \item{jitter}{logical;  if \code{TRUE}, add a small amount of noise to
    the point locations.}
  \item{add}{logical; if \code{TRUE}, add to current \code{rgl} graph.}
  \item{...}{material and texture properties. See \code{rgl.material}
    for details.}
}
\references{ 
   Daniel Adler, Oleg Nenadic and Walter Zucchini (2003)
   RGL: A R-library for 3D visualization with OpenGL
}
\seealso{
  \code{\link{image}}, \code{\link[rgl]{sprites3d}},
  \code{\link[rgl]{points3d}}, \code{\link{jitter}}.
}
\examples{
    # view density of mixture of tri-variate normals
    nmix3 <- function(x, y, z, m, s) {
      0.4 * dnorm(x, m, s) * dnorm(y, m, s) * dnorm(z, m, s) +
        0.3 * dnorm(x, -m, s) * dnorm(y, -m, s) * dnorm(z, -m, s) +
          0.3 * dnorm(x, m, s) * dnorm(y, -1.5 * m, s) * dnorm(z, m, s)
    }
    f <- function(x,y,z) nmix3(x,y,z,.5,.5)
    x<-seq(-2,2,len=50)
    g <- expand.grid(x = x, y = x, z = x)
    v <- array(f(g$x, g$y, g$z), c(length(x), length(x), length(x)))
    image3d(v)
    image3d(v, jitter = TRUE)
}
\keyword{hplot}
