% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{r2md}
\alias{r2md}
\title{Convert R code into (R) Markdown-syntax text}
\usage{
r2md(from = NA)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}
}
\value{
R markdown-syntax text.
}
\description{
Convert R code into (R) Markdown-syntax text
}
\examples{
input <- system.file("examples/mindr-r.R", package = "mindr")
input_txt <- readLines(input, encoding = "UTF-8")
output_txt <- r2md(from = input_txt)
output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".Rmd")
writeLines(output_txt, output, useBytes = TRUE)
# file.show(input) # Open the input file file.show(output) # Open the output
# file
message("Input:  ", input, "\nOutput: ", output)
# file.remove(output) # remove the output file
}
