#' \emph{Migration indices}
#'
#' This package provides various indices, like Crude Migration Rate, different Gini indices or the Coefficient of Variation among others, to show the (un)equality of migration.
#' @docType package
#' @name migration.indices
NULL


#' Global Bilateral Migration Database (2000)
#'
#' Global (country-to-country) matrix of bilateral migrant stocks in 2000 with 226 economies involved.
#' @name migration.world
#' @format migration matrix
#' @docType data
#' @references \itemize{
#'   \item World Bank (2010): Global Bilateral Migration Database. \url{http://data.worldbank.org/data-catalog/global-bilateral-migration-database}
#' }
#' @keywords data
NULL


#' Hypotetical Migration Matrix
#'
#' A small (3x3) hypotetical migration matrix.
#' @name migration.hyp
#' @format migration matrix
#' @docType data
#' @references \itemize{
#'   \item David A. Plane and Gordon F. Mulligan (1997): Measuring Spatial Focusing in a Migration System. \emph{Demography} \bold{34}, pp. 253
#'   \item Andrei Rogers and Stuart Sweeney (1998) Measuring the Spatial Focus of Migration Patterns. \emph{The Professional Geographer} \bold{50}, 232--242
#' }
#' @keywords data
#' @aliases migration.hyp2
NULL
