% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{brokerage_census}
\alias{brokerage_census}
\alias{node_brokerage_census}
\alias{network_brokerage_census}
\alias{node_brokering_activity}
\alias{node_brokering_exclusivity}
\alias{node_brokering}
\title{Censuses of brokerage motifs}
\usage{
node_brokerage_census(.data, membership, standardized = FALSE)

network_brokerage_census(.data, membership, standardized = FALSE)

node_brokering_activity(.data, membership)

node_brokering_exclusivity(.data, membership)

node_brokering(.data, membership)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{membership}{A vector of partition membership as integers.}

\item{standardized}{Whether the score should be standardized
into a \emph{z}-score indicating how many standard deviations above
or below the average the score lies.}
}
\description{
These functions include ways to take a census of the brokerage positions of nodes
in a network:
\itemize{
\item \code{node_brokerage_census()} returns the Gould-Fernandez brokerage
roles played by nodes in a network.
\item \code{network_brokerage_census()} returns the Gould-Fernandez brokerage
roles in a network.
}
}
\examples{
node_brokerage_census(manynet::ison_networkers, "Discipline")
network_brokerage_census(manynet::ison_networkers, "Discipline")
node_brokering_exclusivity(ison_networkers, "Discipline")
}
\references{
Gould, R.V. and Fernandez, R.M. 1989.
“Structures of Mediation: A Formal Approach to Brokerage in Transaction Networks.”
\emph{Sociological Methodology}, 19: 89-126.

Jasny, Lorien, and Mark Lubell. 2015.
“Two-Mode Brokerage in Policy Networks.”
\emph{Social Networks} 41:36–47.
\doi{10.1016/j.socnet.2014.11.005}.

Hamilton, Matthew, Jacob Hileman, and Orjan Bodin. 2020.
"Evaluating heterogeneous brokerage: New conceptual and methodological approaches
and their application to multi-level environmental governance networks"
\emph{Social Networks} 61: 1-10.
\doi{10.1016/j.socnet.2019.08.002}
}
\seealso{
Other motifs: 
\code{\link{network_census}},
\code{\link{node_census}}
}
\concept{motifs}
