% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cluster.R
\name{cluster}
\alias{cluster}
\alias{cluster_hierarchical}
\alias{cluster_concor}
\title{Methods for equivalence clustering}
\usage{
cluster_hierarchical(census, distance)

cluster_concor(object, census)
}
\arguments{
\item{census}{A matrix returned by a \verb{node_*_census()} function.}

\item{distance}{Character string indicating which distance metric
to pass on to \code{stats::dist}.
By default \code{"euclidean"}, but other options include
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"}, and \code{"minkowski"}.
Fewer, identifiable letters, e.g. \code{"e"} for Euclidean, is sufficient.}

\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
Methods for equivalence clustering
}
\section{Functions}{
\itemize{
\item \code{cluster_hierarchical}: Returns a hierarchical clustering object
created by \code{stats::hclust()}

\item \code{cluster_concor}: Returns a hierarchical clustering object
created from a convergence of correlations procedure (CONCOR)
}}

\references{
Breiger, Ronald L., Scott A. Boorman, and Phipps Arabie. 1975.
"An Algorithm for Clustering Relational Data with Applications to
Social Network Analysis and Comparison with Multidimensional Scaling".
\emph{Journal of Mathematical Psychology}, 12: 328-83.
\doi{10.1016/0022-2496(75)90028-0}.
}
