% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisreg.R
\name{poisreg}
\alias{poisreg}
\title{Poisson regression}
\usage{
poisreg(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  start = NULL,
  mixing = c("none", "gamma", "lognorm"),
  method = c("bfgs", "newton"),
  vlink = c("nb1", "nb2"),
  ...
)
}
\arguments{
\item{formula}{a symbolic description of the model, (for the count
component and for the selection equation)}

\item{data}{a data frame}

\item{subset, weights, na.action, offset}{see \code{stats::lm},}

\item{start}{a vector of starting values}

\item{mixing}{the mixing distribution, one of \code{"none"}, \code{"gamma"}
and \code{"lognorm"}}

\item{method}{the optimization method, one of \code{"newton"} and \code{"bfgs"}}

\item{vlink}{one of \code{"nb1"} and \code{"nb2"}}

\item{...}{further arguments}
}
\value{
an object of class \code{c("poisreg", "micsr")}, see
\code{micsr::micsr} for further details.
}
\description{
A unified interface to perform Poisson, Negbin and log-normal Poisson models
}
\examples{
nb1 <- poisreg(trips ~ workschl + size + dist + smsa + fulltime + distnod +
               realinc + weekend + car, trips, mixing = "gamma", vlink = "nb1")
}
\keyword{models}
