% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnaManipulate.R
\name{reverseComplement}
\alias{reverseComplement}
\title{Reverse-complementation of DNA}
\usage{
reverseComplement(nuc.sequences)
}
\arguments{
\item{nuc.sequences}{Character vector containing the nucleotide sequences.}
}
\value{
A character vector of reverse-complemented sequences.
}
\description{
The standard reverse-complement of nucleotide sequences.
}
\details{
This function uses the Biostrings::reverseComplement function.
}
\examples{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
reverseComplement(fdta$Sequence)

}
\author{
Lars Snipen and Kristian Hovde Liland.
}

