% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio.R
\name{odds_ratio}
\alias{odds_ratio}
\title{Calculates the odds ratio (OR) and standard error.}
\usage{
odds_ratio(y, x, formula, data)
}
\arguments{
\item{y}{0-1 binary response variable.}

\item{x}{0-1 binary independent variable.}

\item{formula}{A formula object to specify the model as normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{df2milist} or \code{mids2milist}.}
}
\value{
The odds ratio, related standard error and complete
data degrees of freedom (dfcom) as n-2.
}
\description{
\code{odds_ratio} Calculates the odds ratio and standard error
and degrees of freedom to be used in function \code{with.milist}.
}
\details{
Note that the standard error of the OR is in fact the
standard error of the (natural) log odds ratio.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=odds_ratio(Chronic ~ Radiation))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_odds_ratio}}
}
\author{
Martijn Heymans, 2021
}
