% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cindex.R
\name{cindex}
\alias{cindex}
\title{Calculates the c-index and standard error}
\usage{
cindex(formula, data)
}
\arguments{
\item{formula}{A formula object to specify the model as
normally used by glm or coxph.}

\item{data}{An object of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
The c-index, related standard error and
complete data degrees of freedom (dfcom) as n-1.
}
\description{
\code{cindex} Calculates the c-index and standard error for
logistic and Cox regression models and the degrees of freedom
to be further used in function \code{with.milist}.
}
\examples{

 imp_dat <- df2milist(lbpmilr, impvar="Impnr")
 ra <- with(data=imp_dat,
 expr = cindex(glm(Chronic ~ Gender + Radiation, family=binomial)))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_cindex}}
}
\author{
Martijn Heymans, 2021
}
