% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelations.R
\name{plotCorrelations}
\alias{plotCorrelations}
\title{plotCorrelations}
\usage{
plotCorrelations(
  miceObj,
  vars = names(miceObj$callParams$vars),
  factCorrMetric = "CramerV",
  numbCorrMetric = "pearson",
  ...
)
}
\arguments{
\item{miceObj}{an object of class miceDefs, created by the miceRanger function.}

\item{vars}{the variables you want to plot. Default is to plot all variables. Can be a vector of
variable names, or one of 'allNumeric' or 'allCategorical'}

\item{factCorrMetric}{The correlation metric for categorical variables. Can be one of:
\itemize{
  \item {CramerV} Cramer's V correlation metric.
  \item {Chisq} Chi Square test statistic.
  \item {TschuprowT} Tschuprow's T correlation metric.
  \item {Phi} (Binary Variables Only) Phi coefficient.
  \item {YuleY} (Binary Variables Only) Yule's Y, also known as coefficient of colligation
  \item {YuleQ} (Binary Variables Only) Yule's Q, related to Yule's Y by Q=2Y/(1+Y^2)
}}

\item{numbCorrMetric}{The correlation metric for numeric variables. Can be one of:
\itemize{
  \item {pearson} Pearson's Correlation Coefficient
  \item {spearman} Spearman's Rank Correlation Coefficient
  \item {kendall} Kendall's Rank Correlation Coefficient
  \item {Rsquared} R-squared
}}

\item{...}{Other arguments to pass to grid.arrange()}
}
\value{
nothing.
}
\description{
Create a impDefs object, which contains information about the imputation process.
}
\examples{
data("sampleMiceDefs")
plotCorrelations(sampleMiceDefs)
}
