% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibind.r
\name{ibind}
\alias{ibind}
\title{Enlarge number of imputations by combining \code{mids} objects}
\usage{
ibind(x, y)
}
\arguments{
\item{x}{A \code{mids} object.}

\item{y}{A \code{mids} object.}
}
\value{
An S3 object of class \code{mids}
}
\description{
This function combines two \code{mids} objects \code{x} and \code{y} into a
single \code{mids} object, with the objective of increasing the number of 
imputed data sets. If the number of imputations in \code{x} and \code{y} are 
\code{m(x)} and \code{m(y)}, then the combined object will have 
\code{m(x)+m(y)} imputations.
}
\details{
The two \code{mids} objects are required to 
have the same underlying multiple imputation model and should 
be fitted on the same data.
}
\examples{
data(nhanes)
imp1 <- mice(nhanes, m = 1, maxit = 2, print = FALSE)
imp1$m

imp2 <- mice(nhanes, m = 3, maxit = 3, print = FALSE)
imp2$m

imp12 <- ibind(imp1, imp2)
imp12$m
plot(imp12)
}
\seealso{
\code{\link[=mids-class]{mids}}, \code{\link{rbind.mids}}, \code{\link{cbind.mids}}
}
\author{
Karin Groothuis-Oudshoorn, Stef van Buuren
}
\keyword{manip}
