% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mir_threshold.R
\name{count_mir_threshold}
\alias{count_mir_threshold}
\title{Count occurrence of miRNA names above threshold}
\usage{
count_mir_threshold(df, threshold = 1, col.mir = miRNA, col.pmid = PMID)
}
\arguments{
\item{df}{Data frame containing miRNA names and
PubMed-IDs.}

\item{threshold}{Integer or float. If \code{threshold >= 1}, counts number of
miRNA names in at least \code{threshold} abstracts.
If \code{threshold} is between 0 and 1, counts number of miRNA names mentioned
in at least \code{threshold} abstracts of all abstracts in \code{df}.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}
}
\value{
Integer with the number of distinct miRNA names in \code{df}.
}
\description{
Count occurrence of miRNA names above a threshold.
}
\details{
Count occurrence of miRNA names above a threshold. This threshold can either
be an absolute value, e.g. 3, or a float between 0 and 1, e.g. 0.2.
If \code{threshold} is an absolute value, number of distinct miRNA names mentioned
in at least \code{threshold} abstracts is returned.
If \code{threshold} is a float between 0 and 1, number of distinct miRNA names
mentioned in at least \code{threshold} abstracts
of all abstracts in \code{df} is returned.
}
\seealso{
\code{\link[=plot_mir_count_threshold]{plot_mir_count_threshold()}}, \code{\link[=count_mir]{count_mir()}}, \code{\link[=plot_mir_count]{plot_mir_count()}}

Other count functions: 
\code{\link{count_mir}()},
\code{\link{count_snp}()},
\code{\link{plot_mir_count_threshold}()},
\code{\link{plot_mir_count}()}
}
\concept{count functions}
