% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{calc_lagistic_fit_lag}
\alias{calc_lagistic_fit_lag}
\title{calc_lagistic_fit_lag}
\usage{
calc_lagistic_fit_lag(
  data,
  n0,
  init_gr_rate = NULL,
  init_K = NULL,
  init_lag = NULL,
  algorithm,
  max_iter,
  return_all_params = FALSE,
  min_b = 0.2,
  min_a = 0.8
)
}
\arguments{
\item{data}{a data frame with two required columns names: "time" and "biomass",and one optional column: "curve_id"
This is data from may come from multiple growth curves}

\item{n0}{a data frame describing initial biomass for each of the curves, i.e. it has two obligatory columns: "curve_id", "N0"}

\item{init_gr_rate}{initial value for the growth rate, defaults to NULL in which case it will be approximated based on the data}

\item{init_K}{initial value for the saturation parameter K, defaults to NULL in which case it will be approximated based on the data}

\item{init_lag}{initial value for the lag parameter, defaults to NULL in which case it will be approximated based on the data}

\item{algorithm}{eg. "auto", "Levenberg-Marquardt", "port"}

\item{max_iter}{Maximum number of iterations}

\item{return_all_params}{defaults to FALSE, TRUE if you also want to get K and growth.rate apart from lag}

\item{min_b}{defaults to 0.2; mina and minb define where to look for exponential phase: it will be where the biomass is between min + (max-min)*(lower.bound.for.gr TO upper.bound.for.gr)}

\item{min_a}{defaults to 0.8}
}
\value{
growth curve data with additional columns  ('lag', and predicted biomass 'predicted'), and the fitting object if return.all.params was set to TRUE
}
\description{
Calculates lag based on fitting logistic model to data
}
