% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmvggd.R
\name{plotmvggd}
\alias{plotmvggd}
\title{Plot of the Bivariate Generalised Gaussian Density}
\usage{
plotmvggd(mu, Sigma, beta, xlim = c(mu[1] + c(-10, 10)*Sigma[1, 1]),
                 ylim = c(mu[2] + c(-10, 10)*Sigma[2, 2]), n = 101,
                 xvals = NULL, yvals = NULL, xlab = "x", ylab = "y",
                 zlab = "f(x,y)", col = "gray", tol = 1e-6, ...)
}
\arguments{
\item{mu}{length 2 numeric vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order 2. The dispersion matrix.}

\item{beta}{positive real number. The shape of the first distribution.}

\item{xlim, ylim}{x-and y- limits.}

\item{n}{A one or two element vector giving the number of steps in the x and y grid, passed to \code{\link{plot3d.function}}.}

\item{xvals, yvals}{The values at which to evaluate \code{x} and \code{y}. If used, \code{xlim} and/or \code{ylim} are ignored.}

\item{xlab, ylab, zlab}{The axis labels.}

\item{col}{The color to use for the plot. See \code{\link{plot3d.function}}.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma, for the estimation of the density. see \code{\link{mvdggd}}.}

\item{...}{Additional arguments to pass to \code{\link{plot3d.function}}.}
}
\value{
Returns invisibly the probability density function.
}
\description{
Plots the probability density of the generalised Gaussian distribution with 2 variables
with mean vector \code{mu}, dispersion matrix \code{Sigma} and shape parameter \code{beta}.
}
\examples{
mu <- c(1, 4)
Sigma <- matrix(c(0.8, 0.2, 0.2, 0.2), nrow = 2)
beta <- 0.74
plotmvggd(mu, Sigma, beta)

}
\references{
E. Gomez, M. Gomez-Villegas, H. Marin. A Multivariate Generalization of the Power Exponential Family of Distribution.
Commun. Statist. 1998, Theory Methods, col. 27, no. 23, p 589-600.
\doi{10.1080/03610929808832115}
}
\seealso{
\code{\link{contourmvggd}}: contour plot of a bivariate generalised Gaussian density.

\code{\link{mvdggd}}: Probability density of a multivariate generalised Gaussian distribution.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
