% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordGEE2.R
\name{ordGEE2}
\alias{ordGEE2}
\title{ordGEE2}
\usage{
ordGEE2(formula, id, data, OR.str = "exchangeable", maxit = 50, tol = 0.001)
}
\arguments{
\item{formula}{a formula object: a symbolic description of the model with error-prone
response, error-prone covariates and other covariates.}

\item{id}{a character object which records individual id in the data.}

\item{data}{a dataframe or matrix of the observed data, including id, error-prone ordinal response
error-prone ordinal covaritaes, other covariates.}

\item{OR.str}{a character object. The default value is "exchangeable", 
corresponding to the structure where the association between two paired 
responses is considered to be a constant. The other option is "log-linear" 
which  indicates the log-linear association between two paired responses.}

\item{maxit}{an integer which specifies the maximum number of iterations. The default is 50.}

\item{tol}{a numeric object which indicates the tolerance threshold. The default is 1e-3.}
}
\value{
A list with component
    \item{beta}{Coefficients in the order as those specified in the formula for the response and covariates.}
    \item{alpha}{Coefficients for paired responses global odds ratios. The number of 
    alpha coefficients corresponds to the paired responses odds ratio structure selected
     in OR.str. When OR.str="exchangeable", only one baseline alpha 
     is fitted. When OR.str="log-linear", baseline, first order, 
     second order (interaction) terms are fitted.}
    \item{variance}{variance-covariance matrix of the estimator of all parameters.}
    \item{convergence}{a logical variable; TRUE if the model converges.}
    \item{iteration}{the number of iterations for the estimates of the model parameters to converge.}
    \item{differ}{a list of difference of estimation for convergence}   
    \item{call}{Function called}

A list with component
    \item{beta}{Coefficients in the order of 1) all non-baseline levels for response,
    2) covariates - same order as specified in the formula}
    \item{alpha}{Coefficients for paired responses global odds ratios. Number of alpha
    coefficients corresponds to the paired responses odds ratio structure selected in "OR.str";
    when OR.str="exchangeable", only one baseline alpha is fitted.}
    \item{variance}{variance-covariance matrix of all fitted parameters}
    \item{convergence}{a logical variable, TRUE if the model converges}
    \item{iteration}{number of iterations for the model to converge}
    \item{differ}{a list of difference of estimation for convergence}   ##
    \item{call}{Function called}
}
\description{
This function provides a naive approach to estimate the data without any correction
or misclassification parameters. This may lead to biased estimation for response
parameters.
}
\examples{
  data(obs1)
  obs1$Y <- as.factor(obs1$Y)
  obs1$X <- as.factor(obs1$X)
  obs1$visit <- as.factor(obs1$visit)
  obs1$treatment <- as.factor(obs1$treatment)
  obs1$S <- as.factor(obs1$S)
  obs1$W <- as.factor(obs1$W)
  naigee.fit = ordGEE2(formula = S~W+treatment+visit, id = "ID",
                       data = obs1, OR.str = "exchangeable")

}
