# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @describeIn build_U Build the U matrix (C++ implementation)
#' @templateVar n_vars TRUE
#' @templateVar n_lags TRUE
#' @keywords internal
#' @template man_template
build_U_cpp <- function(Pi, n_determ, n_vars, n_lags) {
    .Call(`_mfbvar_build_U_cpp`, Pi, n_determ, n_vars, n_lags)
}

#' @title Kalman filter and smoother
#'
#' @description Kalman filter and smoother (\code{kf_ragged}) and simulation smoother (\code{kf_sim_smooth}) for mixed-frequency data with ragged edges. This function is more computationally efficient than using a companion form representation.
#' @param y_ matrix with the data
#' @param Phi_ matrix with the autoregressive parameters, where the last column is the intercept
#' @param Sigma_ error covariance matrix
#' @param Lambda_ aggregation matrix (for quarterly variables only)
#' @param n_q_ number of quarterly variables
#' @param T_b_ final time period where all monthly variables are observed
#' @keywords internal
#' @return For \code{kf_ragged}, a list with elements:
#' \item{a}{The one-step predictions (for the compact form)}
#' \item{a_tt}{The filtered estimates (for the compact form)}
#' \item{a_tT}{The smoothed estimates (for the compact form)}
#' \item{Z_tT}{The smoothed estimated (for the original form)}
#' @details The returned matrices have the same number of rows as \code{y_}, but the first \code{n_lags} rows are zero.
kf_loglike <- function(y_, Phi_, Sigma_, Lambda_, a00, P00) {
    .Call(`_mfbvar_kf_loglike`, y_, Phi_, Sigma_, Lambda_, a00, P00)
}

#' @title Kalman filter and smoother
#'
#' @description Kalman filter and smoother (\code{kf_ragged}) and simulation smoother (\code{kf_sim_smooth}) for mixed-frequency data with ragged edges. This function is more computationally efficient than using a companion form representation.
#' @param y_ matrix with the data
#' @param Phi_ matrix with the autoregressive parameters, where the last column is the intercept
#' @param Sigma_ error covariance matrix
#' @param Lambda_ aggregation matrix (for quarterly variables only)
#' @param n_q_ number of quarterly variables
#' @param T_b_ final time period where all monthly variables are observed
#' @keywords internal
#' @return For \code{kf_ragged}, a list with elements:
#' \item{a}{The one-step predictions (for the compact form)}
#' \item{a_tt}{The filtered estimates (for the compact form)}
#' \item{a_tT}{The smoothed estimates (for the compact form)}
#' \item{Z_tT}{The smoothed estimated (for the original form)}
#' @details The returned matrices have the same number of rows as \code{y_}, but the first \code{n_lags} rows are zero.
kf_ragged <- function(y_, Phi_, Sigma_, Lambda_, Z1_, n_q_, T_b_) {
    .Call(`_mfbvar_kf_ragged`, y_, Phi_, Sigma_, Lambda_, Z1_, n_q_, T_b_)
}

#' @describeIn kf_ragged Simulation smoother
#' @param Z1 initial values, with \code{n_lags} rows and same number of columns as \code{y_}
#' @return For \code{kf_sim_smooth}, a matrix with the draw from the posterior distribution.
kf_sim_smooth <- function(y_, Phi_, Sigma_, Lambda_, Z1_, n_q_, T_b_) {
    .Call(`_mfbvar_kf_sim_smooth`, y_, Phi_, Sigma_, Lambda_, Z1_, n_q_, T_b_)
}

#' @title Find maximum eigenvalue
#'
#' @description The function computes the maximum eigenvalue.
#' @aliases max_eig max_eig_cpp
#' @templateVar A TRUE
#' @template man_template
#' @keywords internal
#' @return The maximum eigenvalue.
max_eig_cpp <- function(A) {
    .Call(`_mfbvar_max_eig_cpp`, A)
}

#' @rdname dnorminvwish
#' @keywords internal
rmatn <- function(M, Q, P) {
    .Call(`_mfbvar_rmatn`, M, Q, P)
}

#' @rdname dnorminvwish
#' @keywords internal
rinvwish <- function(v, S) {
    .Call(`_mfbvar_rinvwish`, v, S)
}

#' @rdname dmultn
#' @keywords internal
rmultn <- function(m, Sigma) {
    .Call(`_mfbvar_rmultn`, m, Sigma)
}

#' @title Smooth and sample from the smoothed distribution
#'
#' @description Functions for smoothing and sampling from the (smoothed) distribution \eqn{p(Z_{1:T}|Y_{1:T}, \Theta)}.
#' @details Implemented in C++.
#' @aliases smoother simulation_smoother generate_mhh loglike
#' @describeIn smoother Compute smoothed states
#' @templateVar Y TRUE
#' @templateVar Lambda TRUE
#' @templateVar Pi_comp TRUE
#' @templateVar Q_comp TRUE
#' @templateVar n_T TRUE
#' @templateVar n_vars TRUE
#' @templateVar n_comp TRUE
#' @templateVar z0 TRUE
#' @templateVar P0 TRUE
#' @template man_template
#' @keywords internal
#' @return For \code{loglike}:
#' \item{}{An \code{n_T}-long vector of the log-likelihoods. \code{exp(sum(loglike(...)))} is the likelihood.}
loglike <- function(Y, Lambda, Pi_comp, Q_comp, n_T, n_vars, n_comp, z0, P0) {
    .Call(`_mfbvar_loglike`, Y, Lambda, Pi_comp, Q_comp, n_T, n_vars, n_comp, z0, P0)
}

