% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivar.R
\name{adf}
\alias{adf}
\title{Estimation of the bivariate angular dependence function}
\usage{
adf(
  xdat,
  qlev = 0.95,
  estimator = c("hill", "mle", "bayes"),
  level = 0.95,
  ties.method = "random",
  angles = seq(0, 1, by = 0.02),
  plot = TRUE
)
}
\arguments{
\item{xdat}{an \eqn{n} by \eqn{2} matrix of multivariate observations}

\item{qlev}{quantile level on uniform scale at which to threshold data. Default to 0.95}

\item{estimator}{string indicating the estimation method}

\item{level}{level for confidence intervals, default to 0.95}

\item{ties.method}{method for handling of ties in rank transformation}

\item{angles}{vector of angles at which to evaluate the angular dependence function
The confidence intervals are based on normal quantiles. The standard errors for the \code{hill}
are based on the asymptotic covariance and that of the \code{mle} derived using the delta-method.
Bayesian posterior predictive interval estimates are obtained using ratio-of-uniform sampling with flat priors:
the shape parameters are constrained to lie within the triangle, as are frequentist point estimates
which are adjusted post-inference.}

\item{plot}{logical indicating whether to plot the function, defaults to \code{TRUE}}
}
\value{
a plot of the angular dependence function if \code{plot=TRUE}, plus an invisible list with components
\itemize{
\item \code{angle} the sequence of angles in (0,1) at which the \code{lambda} values are evaluated
\item \code{coef} point estimates of the angular dependence function
\item \code{lower} \code{level}\% confidence interval for lambda (lower bound)
\item \code{upper} \code{level}\% confidence interval for lambda (upper bound)
}
}
\description{
Estimation of the bivariate angular dependence function
}
\examples{
set.seed(12)
dat <- mev::rmev(n = 1000, d = 2, model = "log", param = 0.1)
adf(xdat = dat, estimator = 'hill')
}
\references{
J.L. Wadsworth and J.A. Tawn (2013). A new representation for multivariate tail probabilities, \emph{Bernoulli}, 19(\bold{5B}), 2689-2714.
}
