% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgplikelihoods.R
\name{clikmgp}
\alias{clikmgp}
\title{Censored likelihood for multivariate generalized Pareto distributions}
\usage{
clikmgp(
  dat,
  thresh,
  mthresh = thresh,
  loc,
  scale,
  shape,
  par,
  model = c("br", "xstud", "log"),
  likt = c("mgp", "pois", "binom"),
  lambdau = 1,
  ...
)
}
\arguments{
\item{dat}{matrix of observations}

\item{thresh}{functional threshold for the maximum}

\item{mthresh}{vector of individuals thresholds under which observations are censored}

\item{loc}{vector of location parameter for the marginal generalized Pareto distribution}

\item{scale}{vector of scale parameter for the marginal generalized Pareto distribution}

\item{shape}{vector of shape parameter for the marginal generalized Pareto distribution}

\item{par}{list of parameters: \code{alpha} for the logistic model, \code{Lambda} for the Brown--Resnick model or else \code{Sigma} and \code{df} for the extremal Student.}

\item{model}{string indicating the model family, one of \code{"log"}, \code{"br"} or \code{"xstud"}}

\item{likt}{string indicating the type of likelihood, with an additional contribution for the non-exceeding components: one of  \code{"mgp"}, \code{"binom"} and \code{"pois"}.}

\item{lambdau}{vector of marginal rate of marginal threshold exceedance.}

\item{...}{additional arguments (see Details)}
}
\value{
the value of the log-likelihood with \code{attributes} \code{expme}, giving the exponent measure
}
\description{
Censored likelihood for the logistic distribution and the Brown--Resnick and extremal Student processes.
}
\details{
Optional arguments can be passed to the function via \code{...}
\itemize{
\item \code{censored} matrix of booleans and \code{NA} indicating whether observations \code{dat} fall below the mthreshold \code{mthresh}
\item \code{cl} cluster instance  created by \code{makeCluster} (default to \code{NULL})
\item \code{ncors} number of cores for parallel computing of the likelihood
\item \code{numAbovePerRow} number of observations above mthreshold (non-missing) per row
\item \code{numAbovePerCol} number of observations above mthreshold (non-missing) per column
\item \code{mmax} maximum per column
\item \code{B1} number of replicates for quasi Monte Carlo integral for the exponent measure
\item \code{B2} number of replicates for quasi Monte Carlo integral for the censored intensity contribution
\item \code{genvec1} generating vector for the quasi Monte Carlo routine (exponent measure), associated with \code{B1}
\item \code{genvec2} generating vector for the quasi Monte Carlo routine (individual obs contrib), associated with \code{B2}
}
}
\note{
The location and scale parameters are not identifiable unless one of them is fixed.
}
