% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{fit.rlarg}
\alias{fit.rlarg}
\title{Maximum likelihood estimates of point process for the r-largest observations}
\usage{
fit.rlarg(xdat, start = NULL, method = c("nlminb", "BFGS"), show = FALSE)
}
\arguments{
\item{xdat}{a numeric vector of data to be fitted.}

\item{start}{numeric vector of starting values}

\item{method}{the method to be used. See \bold{Details}. Can be abbreviated.}

\item{show}{logical; if \code{TRUE} (the default), print details of the fit.}
}
\value{
a list containing the following components:
\itemize{
\item \code{estimate} a vector containing all the maximum likelihood estimates.
\item \code{std.err} a vector containing the standard errors.
\item \code{vcov} the variance covariance matrix, obtained as the numerical inverse of the observed information matrix.
\item \code{method} the method used to fit the parameter.
\item \code{nllh} the negative log-likelihood evaluated at the parameter \code{estimate}.
\item \code{convergence} components taken from the list returned by \code{\link[alabama]{auglag}}.
Values other than \code{0} indicate that the algorithm likely did not converge.
\item \code{counts} components taken from the list returned by \code{\link[alabama]{auglag}}.
\item \code{xdat} an \code{n} by \code{r} matrix of data
}
}
\description{
This uses a constrained optimization routine to return the maximum likelihood estimate
based on an \code{n} by \code{r} matrix of observations. Observations should be ordered, i.e.,
the \code{r}-largest should be in the last column.
}
\examples{
xdat <- rrlarg(n = 10, loc = 0, scale = 1, shape = 0.1, r = 4)
fit.rlarg(xdat)
}
