% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/binomial.twostage.R
\name{easy.binomial.twostage}
\alias{easy.binomial.twostage}
\title{Fits two-stage binomial for describing depdendence in binomial data
using marginals that are on logistic form using the binomial.twostage funcion, but
call is different and easier and the data manipulation is build into the function.
Useful in particular for family design data.}
\usage{
easy.binomial.twostage(margbin = NULL, data = sys.parent(),
  score.method = "nlminb", response = "response", id = "id", Nit = 60,
  detail = 0, silent = 1, weights = NULL, control = list(),
  theta = NULL, theta.formula = NULL, desnames = NULL, deshelp = 0,
  var.link = 1, iid = 1, step = 0.5, model = "plackett",
  marginal.p = NULL, strata = NULL, max.clust = NULL,
  se.clusters = NULL)
}
\arguments{
\item{margbin}{Marginal binomial model}

\item{data}{data frame}

\item{score.method}{Scoring method}

\item{response}{name of response variable in data frame}

\item{id}{name of cluster variable in data frame}

\item{Nit}{Number of iterations}

\item{detail}{Detail for more output for iterations}

\item{silent}{Debug information}

\item{weights}{Weights for log-likelihood, can be used for each type of outcome in 2x2 tables.}

\item{control}{Optimization arguments}

\item{theta}{Starting values for variance components}

\item{theta.formula}{design for depedence, either formula or design function}

\item{desnames}{names for dependence parameters}

\item{deshelp}{if 1 then prints out some data sets that are used, on on which the design function operates}

\item{var.link}{Link function for variance}

\item{iid}{Calculate i.i.d. decomposition}

\item{step}{Step size}

\item{model}{model}

\item{marginal.p}{vector of marginal probabilities}

\item{strata}{strata for fitting}

\item{max.clust}{max clusters}

\item{se.clusters}{clusters for iid decomposition for roubst standard errors}
}
\description{
If clusters contain more than two times, the algoritm uses a compososite likelihood
based on the pairwise bivariate models.
}
\details{
The reported standard errors are based on the estimated information from the
likelihood assuming that the marginals are known. This gives correct standard errors
in the case of the plackett distribution (OR model for dependence), but incorrect for
the clayton-oakes types model. The OR model is often known as the ALR model, but our fitting
procedures gives correct standard errors and is quite a bit quicker.
}
\examples{
data(twinstut)
twinstut0 <- subset(twinstut, tvparnr<2300000)
twinstut <- twinstut0
theta.des <- model.matrix( ~-1+factor(zyg),data=twinstut0)
margbin <- glm(stutter~factor(sex)+age,data=twinstut0,family=binomial())
bin <- binomial.twostage(margbin,data=twinstut0,
		         clusters=twinstut0$tvparnr,theta.des=theta.des,detail=0,
	                 score.method="fisher.scoring")
summary(bin)

twinstut0$cage <- scale(twinstut0$age)
theta.des <- model.matrix( ~-1+factor(zyg)+cage,data=twinstut0)
bina <- binomial.twostage(margbin,data=twinstut0,
		         clusters=twinstut0$tvparnr,theta.des=theta.des,detail=0,
	                 score.method="fisher.scoring")
summary(bina)

theta.des <- model.matrix( ~-1+factor(zyg)+factor(zyg)*cage,data=twinstut0)
bina <- binomial.twostage(margbin,data=twinstut0,
		         clusters=twinstut0$tvparnr,theta.des=theta.des,detail=0,
	                 score.method="fisher.scoring")
summary(bina)

twinstut0$binstut <- (twinstut0$stutter=="yes")*1
out <- easy.binomial.twostage(stutter~factor(sex)+age,data=twinstut0,
                              response="binstut",id="tvparnr",
			      theta.formula=~-1+factor(zyg1),
                              score.method="fisher.scoring")
summary(out)

## refers to zygosity of first subject in eash pair : zyg1
## could also use zyg2 (since zyg2=zyg1 within twinpair's))
desfs <- function(x,num1="zyg1",namesdes=c("mz","dz","os"))
    c(x[num1]=="mz",x[num1]=="dz",x[num1]=="os")*1

out3 <- easy.binomial.twostage(binstut~factor(sex)+age,
                               data=twinstut0, response="binstut",id="tvparnr",
                               score.method="fisher.scoring",
                               theta.formula=desfs,desnames=c("mz","dz","os"))
summary(out3)

\donttest{ ## Reduce Ex.Timings
n <- 10000
set.seed(100)
dd <- simBinFam(n,beta=0.3)
binfam <- fast.reshape(dd,varying=c("age","x","y"))
## mother, father, children  (ordered)
head(binfam)

########### ########### ########### ########### ########### ###########
####  simple analyses of binomial family data
########### ########### ########### ########### ########### ###########
desfs <- function(x,num1="num1",num2="num2")
{
     pp <- 1*(((x[num1]=="m")*(x[num2]=="f"))|(x[num1]=="f")*(x[num2]=="m"))
     pc <- (x[num1]=="m" | x[num1]=="f")*(x[num2]=="b1" | x[num2]=="b2")*1
     cc <- (x[num1]=="b1")*(x[num2]=="b1" | x[num2]=="b2")*1
     c(pp,pc,cc)
}

ud <- easy.binomial.twostage(y~+1,data=binfam,
     response="y",id="id",
     score.method="fisher.scoring",deshelp=0,
     theta.formula=desfs,desnames=c("pp","pc","cc"))
summary(ud)

udx <- easy.binomial.twostage(y~+x,data=binfam,
     response="y",id="id",
     score.method="fisher.scoring",
     theta.formula=desfs,desnames=c("pp","pc","cc"))
summary(udx)

########### ########### ########### ########### ########### ###########
####  now allowing parent child POR to be different for mother and father
########### ########### ########### ########### ########### ###########

desfsi <- function(x,num1="num1",num2="num2")
{
    pp <- (x[num1]=="m")*(x[num2]=="f")*1
    mc <- (x[num1]=="m")*(x[num2]=="b1" | x[num2]=="b2")*1
    fc <- (x[num1]=="f")*(x[num2]=="b1" | x[num2]=="b2")*1
    cc <- (x[num1]=="b1")*(x[num2]=="b1" | x[num2]=="b2")*1
    c(pp,mc,fc,cc)
}

udi <- easy.binomial.twostage(y~+1,data=binfam,
     response="y",id="id",
     score.method="fisher.scoring",
     theta.formula=desfsi,desnames=c("pp","mother-child","father-child","cc"))
summary(udi)

##now looking to see if interactions with age or age influences marginal models
##converting factors to numeric to make all involved covariates numeric
##to use desfai2 rather then desfai that works on binfam

nbinfam <- binfam
nbinfam$num <- as.numeric(binfam$num)
head(nbinfam)

desfsai <- function(x,num1="num1",num2="num2")
{
    pp <- (x[num1]=="m")*(x[num2]=="f")*1
### av age for pp=1 i.e parent pairs
    agepp <- ((as.numeric(x["age1"])+as.numeric(x["age2"]))/2-30)*pp
    mc <- (x[num1]=="m")*(x[num2]=="b1" | x[num2]=="b2")*1
    fc <- (x[num1]=="f")*(x[num2]=="b1" | x[num2]=="b2")*1
    cc <- (x[num1]=="b1")*(x[num2]=="b1" | x[num2]=="b2")*1
    agecc <- ((as.numeric(x["age1"])+as.numeric(x["age2"]))/2-12)*cc
    c(pp,agepp,mc,fc,cc,agecc)
}

desfsai2 <- function(x,num1="num1",num2="num2")
{
    pp <- (x[num1]==1)*(x[num2]==2)*1
    agepp <- (((x["age1"]+x["age2"]))/2-30)*pp ### av age for pp=1 i.e parent pairs
    mc <- (x[num1]==1)*(x[num2]==3 | x[num2]==4)*1
    fc <- (x[num1]==2)*(x[num2]==3 | x[num2]==4)*1
    cc <- (x[num1]==3)*(x[num2]==3 | x[num2]==4)*1
    agecc <- ((x["age1"]+x["age2"])/2-12)*cc ### av age for children
    c(pp,agepp,mc,fc,cc,agecc)
}

udxai2 <- easy.binomial.twostage(y~+x+age,data=binfam,
     response="y",id="id",
     score.method="fisher.scoring",deshelp=0,detail=0,
     theta.formula=desfsai,
     desnames=c("pp","pp-age","mother-child","father-child","cc","cc-age"))
summary(udxai2)
}
}
\keyword{binomial}
\keyword{regression}

