\name{PLOTR}
\alias{PLOTR}

\title{Create Diagnostic Plots for a NONMEM Run}
\description{
\code{PLOTR} is a function to generate diagnostic plots and/or covariate
  evaluation plots following a successful NONMEM run. It is called by
  \code{NONR} if diagnostic plots are requested or can be called independently
  following a NONMEM run. Plots use the \code{pdf} device.  Specific control stream
  syntax is required: see Note under \code{\link{NONR}} .
}
\usage{
PLOTR(
	run, 
	project=getwd(), 
	rundir=filename(project,run),
	grp = NULL,
	onefile=TRUE,
	plotfile=plotfilename(run,project,grp,onefile),
	logtrans = FALSE, 
	dvname = 'DV', 
	epilog=NULL,
	grpnames = NULL, 
	cont.cov = NULL, 
	cat.cov = NULL, 
	par.list = NULL, 
	eta.list = NULL, 
	missing = -99,
	estimated = NULL,
	superset = FALSE,
	...
)
}

\arguments{
  \item{run}{a control stream name, typically integer}

  \item{project}{the directory containing run subdirectories}

  \item{rundir}{path for the NONMEM run directory (\file{project/*}); passed to \code{dataSynthesis}}

  \item{grp}{item in NONMEM data file or output table file (default) that can be used to condition
  plots generated by \code{PLOTR}.  Default value is \code{NULL}. Example:
  \code{grp=c('SEX')}.  Can be more than one, e.g,. \code{grp=c('SEX','TRT')}.  When specifying
  \code{grp}, you can also specify \code{include.all=TRUE}, which will be understood
  by \code{diagnosticPlots} and cause the data to be plotted collectively as well as
  group-wise.}

  \item{onefile}{whether to produce one output file or many; passed to \code{pdf}}

  \item{plotfile}{file name for diagnostic plots, if any.  Default combines
  \file{DiagnosticPlotReview} with the run number, and \code{grp} if present. A counter
  is supplied if \code{onefile=FALSE}.  You can specify an arbitrary name, coordinating
  with the value of \code{onefile}. Any asterisk will be replaced with the run name.}

  \item{logtrans}{Whether to transform the NONMEM output variables \code{DV,
  PRED, and IPRED}. Default: \code{FALSE}.}

  \item{dvname}{name of the dependent variable to use as a label for the diagnostic plots; default: \code{DV}}

  \item{epilog}{User-defined function or script to call at end of \code{NONR} or \code{PLOTR}.
  A non-null argument that cannot be coerced by \code{match.fun} to a function
  will be treated as a filename to be sourced.  All the arguments normally
  available to \code{PLOTR (run, project, dvname, logtrans, grp, grpnames, cont.cov, 
  at.cov, par.list, eta.list, missing, etc)} will be available to \code{epilog}, as well
  as any extra arguments you pass to \code{NONR} or \code{PLOTR}. A
  function can declare any of these, but should at minimum contain the 
  \dots argument. A script can expect them to be present.  See also 
  \file{inst/example/epilog.R} in this package.  To see exactly what is available,
  try \code{epilog=function(...)cat(names(list(...)))}.}  

  \item{grpnames}{optional vector of names for
  \code{grp} item. Vector length must equal number of conditions in
  \code{grp} and must have an order corresponding to an increasing sort
  of \code{grp}.  Default value is \code{NULL}. Example:
  \code{grpnames=c('Male','Female')}}

  \item{cont.cov}{vector of
  continuous covariate names. Names must match those used as column
  headers in the data file (identified in the control stream).  
  Values are retrieved from the data file if not part of the NONMEM $TABLE step. Default
  value is \code{NULL}.  Example: \code{cont.cov=c('AGE','WT','CLCR')}}

  \item{cat.cov}{vector of categorical covariate names. Names must match
  those used as column headers in \code{DataFile}.  Values are retrieved
  from the data file if not part of the NONMEM $TABLE step. Default value is \code{NULL}.  
  Example: \code{cat.cov=c('SEX','FOOD')}} 

  \item{par.list}{vector of NONMEM model
  	  parameter names.  Values are retrieved from \file{*par.TAB} created in
  	  NONMEM if not in \file{*.TAB}. Default value is \code{NULL}.  This can be a superset of parameters
  but only those present in NONMEM output table will be used. Example:
  \code{par.list=c('CL','V','V2','Q')}} 

  \item{eta.list}{vector of NONMEM
  	  model random effect names. Values are retrieved from \file{*par.TAB} created
  	  in NONMEM if not in \file{*.TAB}. Default value is \code{NULL}. This can be a superset of random
  parameters but only those present in NONMEM output table will be used.
  Example: \code{eta.list=c('ETA1','ETA2','ETA3','ETA4')}}

  \item{missing}{numeric item that defines value used to represent
  missing items in the NONMEM data file. Default value is '-99'.}

  \item{estimated}{character vector of names for items that NONMEM estimates.  Used
  to annotate parameter and gradient search plots.}
  
  \item{superset}{(experimental) whether to use \code{superset} as an intermediate 
  	  for dataset creation (instead of \code{dataSynthesis}).  Could give time-varying
  covariates, whereas the default gives only static covariates.}

  \item{\dots}{additional arguments passed to functions that accept them. For example,
  you can pass \code{onefile=FALSE} to \code{pdf}.  You can also pass
  additional lattice arguments to modify the diagnostic plots.}
}
\details{
  PLOTR creates a plotting dataset using \code{dataSynthesis}. It passes this dataset
  to each of \code{diagnosticPlots}, \code{covariatePlots}, and \code{cwresPlots}.  It then 
  calls the function named by the \code{epilog} argument, if any.  The example \code{epilog} 
  (\file{example/epilog.R}) calls \code{dataSynthesis} itself, and does additional plotting.
  
  The \dots argument can be used creatively, with appropriate caution.
  Extra arguments are generally passed to secondary functions that accept them, 
  and even some that don't.  All the lattice plotting functions accept extra 
  arguments, so you may be able to modify the diagnostic plots judiciously
  (with the caviat that the same arguments will be passed to \code{diagnosticPlots}, 
  \code{covariatePlots}, and \code{cwresPlots}. \code{pdf} technically does not accept extra 
  arguments, but any specified argument that it does accept will be passed.  

  File names deserve special consideration.  \code{plotfile} gives
  the name (or naming strategy) for the diagnostic plots; it is passed to \code{pdf}
  and has a suitable default.  If an alternative is specified, \sQuote{*} will be 
  replaced with \code{run}, the run name.  
  For example, the default \file{pdf} name is \file{project/DiagnosticPlotReview_*.pdf}, 
  but you could change it to \file{project/*/DiagnosticPlotReview.pdf}.
     
}
\value{data.frame (the plotting data set), returned invisibly}
\references{\url{http://metrumrg.googlecode.com}}
\author{Tim Bergsma}
\seealso{
	\itemize{
		\item \code{\link{NONR}}
		\item \code{\link{dataSynthesis}}
		\item \code{\link{diagnosticPlots}}
		\item \code{\link{covariatePlots}}
		\item \code{\link{cwresPlots}}
	}
}
\keyword{manip}

